package com.ptteng.academy.admin.controller;


import com.ptteng.academy.admin.model.Constant;
import com.ptteng.academy.admin.service.ConstantService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by asus on 2016/8/20.
 */
@Controller
public class ConstantController {

    private static final Log log = LogFactory.getLog("constant");

    @Autowired
    private ConstantService constantService;


    @RequestMapping(value = "/a/u/constant/weixin", method = RequestMethod.PUT)
    public String addConstantJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, String kefuweixin, String huiyuanweixin) throws Exception {

        log.info("update video img : ");
        try {
            if (DataUtils.isNullOrEmpty(kefuweixin) && DataUtils.isNullOrEmpty(huiyuanweixin)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Long constantKefuId = constantService.getConstantIdByKey("kefuweixin");
            Long constantHuiyuanId = constantService.getConstantIdByKey("huiyuanweixin");

            Constant constantKefu = constantService.getObjectById(constantKefuId);
            constantKefu.setValue(kefuweixin);
            boolean update1 = constantService.update(constantKefu);

            Constant constantHuiyuan = constantService.getObjectById(constantHuiyuanId);
            constantHuiyuan.setValue(huiyuanweixin);
            boolean update2 = constantService.update(constantHuiyuan);


            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update constant error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    @RequestMapping(value = "/a/u/constant/days", method = RequestMethod.PUT)
    public String addConstantDays(HttpServletRequest request, HttpServletResponse response, ModelMap model, String huiyuantianshu) throws Exception {

        log.info("update video img : ");
        try {
            if (DataUtils.isNullOrEmpty(huiyuantianshu)) {
                log.info("params is null");
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            Long constantDayId = constantService.getConstantIdByKey("huiyuantianshu");
            Constant constantDay = constantService.getObjectById(constantDayId);
            constantDay.setValue(huiyuantianshu);
            boolean update2 = constantService.update(constantDay);


            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update img error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    @RequestMapping(value = "/a/u/constant/weixin", method = RequestMethod.GET)
    public String getConstantWeixinValue(HttpServletRequest request, HttpServletResponse response, ModelMap model) {

        log.info("update video img : ");
        try {

            Long constantKefuId = constantService.getConstantIdByKey("kefuweixin");
            Long constantHuiyuanId = constantService.getConstantIdByKey("huiyuanweixin");

            Constant constantKefu = constantService.getObjectById(constantKefuId);
            Constant constantHuiyuan = constantService.getObjectById(constantHuiyuanId);

            model.addAttribute("kefuweixin", constantKefu);
            model.addAttribute("huiyuanweixin", constantHuiyuan);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update img error ");
            model.addAttribute("code", -1);
        }

        return "/academy-course-service/constant/json/constantDetail1";

    }

    @RequestMapping(value = "/a/u/constant/days", method = RequestMethod.GET)
    public String getConstantDaysValue(HttpServletRequest request, HttpServletResponse response, ModelMap model) {

        log.info("update video img : ");
        try {

            Long constantDayId = constantService.getConstantIdByKey("huiyuantianshu");
            Constant constantDay = constantService.getObjectById(constantDayId);

            model.addAttribute("huiyuantianshu", constantDay);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update img error ");
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/academy-course-service/constant/json/constantDetail1";

    }


}
