package com.ptteng.academy.admin.util;

import com.ptteng.academy.user.model.Member;
import com.qding.common.util.DataUtils;

import javax.xml.crypto.Data;

public class AcademyMemberUtil {

    public static Integer paramCheck(Member member) {


        //入参校验
        if (null == member.getName()) {

            return -9012;
        }
        if (null == member.getPeriod()) {

            return -9103;
        }
        if (null == member.getPrice()) {
            return -9104;
        }
        if (null == member.getOrderBy()) {
            return -9106;
        }

        if (DataUtils.isNullOrEmpty(member.getPrice()) || DataUtils.isNullOrEmpty(member.getIosPrice())) {
            return -9107;
        }

        if (DataUtils.isNotNullOrEmpty(member.getDiscountPrice()) ) {

            if (member.getPrice().compareTo(member.getDiscountPrice()) == -1) {
                return -9108;
            }
        }

        if (DataUtils.isNotNullOrEmpty(member.getIosDiscountPrice())) {
            if (member.getIosPrice().compareTo(member.getIosDiscountPrice()) == -1) {
                return -9108;
            }
        }


        return null;

    }

}
