package com.ptteng.academy.admin.util;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class AcademyCourseTaskUtil {

    private static final Log taskLog = LogFactory.getLog("task");
    @Autowired
    private TaskService taskService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private PeriodService periodService;
    public static AcademyCourseTaskUtil academyCourseTaskUtil;
    @PostConstruct
    public void init() {
        academyCourseTaskUtil = this;
    }

    public static Integer nullJudge(Integer taskType, Integer specificType, String taskName, Integer isLock, Integer allowShareToUnlock, List<Unit> unitList, List<Answer> answerList) {


        //任务名校验
        if (taskName == null) {
            return -5005;

        }
        // 校验任务类型的合法性
        if (taskType == null || (!taskType.equals(Task.video_type) && !taskType.equals(Task.exercise_type))) {
            return -5030;

        }
        if (taskType.equals(Task.video_type)) {
            if (!specificType.equals(Task.video_type_exercise) && !specificType.equals(Task.video_type_teaching)) {
                return -5010;

            }
        }
        if (taskType.equals(Task.exercise_type)) {

            if (!specificType.equals(Task.exercise_type_fillIn) && !specificType.equals(Task.exercise_multi_select) && !specificType.equals(Task.exercise_type_TF)) {

                return -5021;

            }
            if (null == unitList || unitList.size() <= 0) {
                return -5022;

            }
            if (null == answerList || answerList.size() <= 0) {
                return -5023;

            }
        }
        /* 校验分享解锁*/
        if (Task.Lock.equals(isLock)) {
            if (!Task.can_unlock_via_sharing.equals(isLock) && !Task.cannot_unlock_via_sharing.equals(isLock)) {
                return -5025;
            }
        }

        if (Task.can_unlock_via_sharing.equals(allowShareToUnlock)) {
            //未上锁课程无必要设置可分享解锁
            if (!Task.Lock.equals(isLock)) {
                return -5024;
            }
            // 非视频任务不能设置是否分享解锁
            if (!Task.video_type.equals(taskType)) {
                return -5026;
            }
        }

        // 非视频任务不能设置是否分享解锁
        if (Task.cannot_unlock_via_sharing.equals(allowShareToUnlock)) {
            if (!Task.video_type.equals(taskType)) {
                return -5026;
            }
        }


        return 0;
    }

    /*校验任务难度等级*/
    public static Integer judgeDifficultyLevel(Integer taskType, Integer specificType, String difficultyLevel, Integer showLevel) {


        if (!Task.video_type.equals(taskType)) {

            return 0;
        }

        if (Task.video_type.equals(taskType) && !Task.video_type_exercise.equals(specificType)) {

            return 0;
        }


        if (!Task.level_showed.equals(showLevel) && !Task.level_hide.equals(showLevel)) {

            taskLog.info("levelShow value is not legal : " + showLevel);
            return -5005;

        }

        if (Task.level_showed.equals(showLevel)) {


            if (DataUtils.isNullOrEmpty(difficultyLevel)) {

                taskLog.info("taskLevel is null while taskLevel is showed");
                return -5007;

            }
            if (!Task.level_one.equals(difficultyLevel) && !Task.level_two.equals(difficultyLevel) && !Task.level_three.equals(difficultyLevel)
                    && !Task.level_four.equals(difficultyLevel) && !Task.level_five.equals(difficultyLevel)) {

                taskLog.info(Task.level_one);
                taskLog.info("difficultyLevel value not legal : " + difficultyLevel);
                return -5008;

            }
        }

        return 0;

    }


    public static List<Long> getNormalTaskIds(List<Long> taskIdList) throws ServiceException, ServiceDaoException, NoSuchFieldException, IllegalAccessException {

        // 任务的上下架情况
        List<Task> taskList = academyCourseTaskUtil.taskService.getObjectsByIds(taskIdList);
        List<Long> normalTaskIds = new ArrayList<>();

        //taskId 的父 period、父 lesson、父 subject 的上下架情况
        List<Long> taFatherPeriodIds = MyListUtil.getDistinctList(Task.class.getDeclaredField("periodId"), taskList);
        List<Long> taFatherLessonIds = MyListUtil.getDistinctList(Task.class.getDeclaredField("lessonId"), taskList);
        List<Long> taFatherSubjectIds = MyListUtil.getDistinctList(Task.class.getDeclaredField("subjectId"), taskList);

        List<Period> taFatherPeriodList = academyCourseTaskUtil.periodService.getObjectsByIds(taFatherPeriodIds);
        List<Lesson> taFatherLessonList = academyCourseTaskUtil.lessonService.getObjectsByIds(taFatherLessonIds);
        List<Subject> taFatherSubjectList = academyCourseTaskUtil.subjectService.getObjectsByIds(taFatherSubjectIds);

        Map<Long, Integer> taFatherPeriodStatusMap = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("status"), taFatherPeriodList);
        Map<Long, Integer> taFatherLessonStatusMap = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("status"), taFatherLessonList);
        Map<Long, Integer> taFatherSubjectStatusMap = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("status"), taFatherSubjectList);

        for (Task ta : taskList) {

            Integer taFatherPeriodStatus = taFatherPeriodStatusMap.get(ta.getPeriodId());
            Integer taFatherLessonStatus = taFatherLessonStatusMap.get(ta.getLessonId());
            Integer taFatherSubjectStatus = taFatherSubjectStatusMap.get(ta.getSubjectId());

            if (!Subject.status_normal.equals(taFatherSubjectStatus) || !Lesson.status_normal.equals(taFatherLessonStatus) || !Period.status_normal.equals(taFatherPeriodStatus)
                    || !Task.status_normal.equals(ta.getStatus())) {
                continue;
            }
            normalTaskIds.add(ta.getId());
        }
        return normalTaskIds;

    }

}
