package com.ptteng.academy.admin.util;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.model.LessonIntroduction;
import com.ptteng.academy.course.model.Subject;
import com.ptteng.academy.course.service.LessonIntroductionService;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.SubjectService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class AcademyCourseLessonUtil {

    private static final Log lessonLog = LogFactory.getLog("lesson");
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private LessonService lessonService;
    public static AcademyCourseLessonUtil academyCourseLessonUtil;
    @Autowired
    public LessonIntroductionService lessonIntroductionService;

    @PostConstruct
    public void init() {
        academyCourseLessonUtil = this;
    }

    public static Integer updateLessonIntroduction(Long lessonId, Long userId, List<LessonIntroduction> introductionList) throws ServiceException, ServiceDaoException {

        List<Long> relationIds = academyCourseLessonUtil.lessonIntroductionService.getLessonIntroductionIdsByLessonId(lessonId, 0, Integer.MAX_VALUE);

        lessonLog.info("relationIds is " + relationIds);
        if (CollectionUtils.isNotEmpty(relationIds)) {
            academyCourseLessonUtil.lessonIntroductionService.deleteList(LessonIntroduction.class, relationIds);
        }

        if (CollectionUtils.isNotEmpty(introductionList)) {
            for (LessonIntroduction intro : introductionList) {
                intro.setLessonId(lessonId);
                intro.setUpdateBy(userId);
            }
            academyCourseLessonUtil.lessonIntroductionService.insertList(introductionList);
        }

        return 0;
    }

    public static List getNormalLessonList(List<Long> lessonIdList) throws ServiceException, ServiceDaoException, NoSuchFieldException, IllegalAccessException {

        List<Lesson> lessonList = academyCourseLessonUtil.lessonService.getObjectsByIds(lessonIdList);
        List<Lesson> normalLessonList = new ArrayList<>();
        //lessonId 的 subject 上下架情况
        List fatherSubjectIdList = MyListUtil.getDistinctList(Lesson.class.getDeclaredField("subjectId"), lessonList);
        List<Subject> fatherSubjectList = academyCourseLessonUtil.subjectService.getObjectsByIds(fatherSubjectIdList);
        Map<Long, Integer> fatherSubjectStatusMap = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("status"), fatherSubjectList);

        for (Lesson lsn : lessonList) {
            Long subjectId = lsn.getSubjectId();

            Integer fatherSubjectStatus = fatherSubjectStatusMap.get(subjectId);
            if (!Subject.status_normal.equals(fatherSubjectStatus) || !Lesson.status_normal.equals(lsn.getStatus()) ) {
                continue;
            }
            normalLessonList.add(lsn);
        }

        return normalLessonList;
    }
}
