package com.ptteng.academy.admin.util;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.model.Article;
import com.ptteng.academy.admin.service.ArticleService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;

@Component
public class AcademyArticleUtil {

    @Autowired
    private ArticleService articleService;

    public static AcademyArticleUtil academyArticleUtil;

    private static final Log articleLog = LogFactory.getLog("article");


    @PostConstruct
    public void init() {
        academyArticleUtil = this;
    }

    public static Integer paramsCheckWhenArticleTypeIsBanner(Article article) throws ServiceException, ServiceDaoException {

        if (!Article.banner.equals(article.getType())) {
            return 0;
        }

        List<Long> ids = null;
        Map<String, Object> param = DynamicUtil.getArticleListParam(null, null, null, 1, 1, null);
        ids = academyArticleUtil.articleService.getIdsByDynamicCondition(Article.class, param, 0, 10);

        articleLog.info("get article list ids is" + ids);

        List<Article> articleList = academyArticleUtil.articleService.getObjectsByIds(ids);
        articleLog.info(articleList.size());
        if (articleList.size() >= 9) {
            return -9201;
        }

        if (DataUtils.isNullOrEmpty(article.getImg())) {
            return -5014;
        }

        // 当 banner 类型为链接
        if (Article.hyperLink.equals(article.getBannerType()) && DataUtils.isNullOrEmpty(article.getContent())) {
            return -1000;
        }
        return 0;

    }


    public static Integer paramsLegal(Article article) {

        Integer articleType = article.getType();
        Integer status = article.getStatus();

        if (Article.Status_Published != status && Article.Status_Unpublished != status) {
            return -4020;
        }
        if (!Article.help.equals(articleType) && !Article.banner.equals(articleType) && !Article.advertising.equals(articleType)) {
            return -5030;
        }

        return 0;
    }

    public static void whenArticleTypeIsHelp(Article article) {

        if (!(Article.help.equals(article.getBannerType()))) {
            return;
        }
        String contents = article.getContent().replaceAll(" ", "&#160;");
        article.setContent(contents);
    }

}
