package com.ptteng.academy.admin.controller.course;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.academy.admin.util.AcademyCourseTaskUtil;
import com.ptteng.academy.admin.util.AcademyUserUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.admin.util.VideoAndVoiceUtil;
import com.ptteng.academy.course.model.*;
import com.ptteng.academy.course.service.*;
import com.ptteng.academy.course.vo.TaskUnit;
import com.ptteng.academy.document.model.UserFavoriteRelation;
import com.ptteng.academy.document.service.UserFavoriteRelationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * Task  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class TaskController {
    private static final Log log = LogFactory.getLog("task");

    @Autowired
    private TaskService taskService;
    @Autowired
    private UnitService unitService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private CookieUtil cookieUtil;
    @Autowired
    private AnswerService answerService;
    @Autowired
    private UserFavoriteRelationService userFavoriteRelationService;


    /**
     * 获得任务详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */

    @RequestMapping(value = "/a/u/task/{id}", method = RequestMethod.GET)
    public String getTaskJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer page, Integer size)
            throws Exception {

        log.info("get data : id= " + id);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        Task task;
        try {
            task = taskService.getObjectById(id);
            if (null == task) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            log.info("get task data is " + task);

            // 设置该 任务的 课程、专题、科目
            Long periodId = task.getPeriodId();
            Long lessonId = task.getLessonId();
            Long subjectId = task.getSubjectId();

            Period period = periodService.getObjectById(periodId);
            Lesson lesson = lessonService.getObjectById(lessonId);
            Subject subject = subjectService.getObjectById(subjectId);

            if (null != period) {
                task.setPeriodName(period.getPeriodName());
            } else {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            if (null != lesson) {
                task.setLessonName(lesson.getLessonName());
            } else {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            if (null != subject) {
                task.setSubjectName(subject.getSubjectName());
            } else {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            List<Long> unitIds = unitService.getUnitIdsByTaskIDOrderBySort(id, start, size);
            List<Long> answerIds = answerService.getAnswerIdsByTaskIdOrderByCreateAt(id, start, size);

            if (unitIds.size() <= 0) {
                log.info("unit is null");
            }
            if (answerIds.size() <= 0) {
                log.info("answer is null");
            }

            List<Unit> unitList = unitService.getObjectsByIds(unitIds);
            List<Answer> answerList = answerService.getObjectsByIds(answerIds);

            model.addAttribute("code", 0);
            model.addAttribute("task", task);
            model.addAttribute("unitList", unitList);
            model.addAttribute("answerList", answerList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get task error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/academy-course-service/task/json/taskDetailJson";
    }

    /*
     * 通过课程id查到任务列表
     * */

    @RequestMapping(value = "/a/u/task/list/{periodId} ", method = RequestMethod.GET)
    public String getTaskListByPeriodIdJson(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, @PathVariable Long periodId) throws Exception {


        List<Long> taskIds = null;
        List<Task> taskList = null;

        try {
            taskIds = taskService.getTaskIdsByPeriodIDOrderBySort(periodId, 0, Integer.MAX_VALUE);

            taskList = taskService.getObjectsByIds(taskIds);

            if (null != taskList && taskList.size() > 0) {
                log.info("get lesson list data is " + taskList.size());
            } else {
                log.info("get lesson list data is null");
            }

            // periodId_alias   lessonId_alias   subjectId_alias
            List<Long> periodIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("periodId"), taskList);
            List<Long> lessonIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("lessonId"), taskList);
            List<Long> subjectIdsR = MyListUtil.getDistinctList(Task.class.getDeclaredField("subjectId"), taskList);

            List<Period> periodList = periodService.getObjectsByIds(periodIdsR);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);

            Map<Long, String> periodId_alias = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("periodName"), periodList);
            Map<Long, String> lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);

            model.addAttribute("taskList", taskList);
            model.addAttribute("periodId_alias", periodId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);
            model.addAttribute("subjectId_alias", subjectId_alias);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get period list by periodId error, lesson id is  " + periodId);
        }

        return "/academy-course-service/task/json/taskListJson";
    }

    /**
     * 更新任务
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param taskUnit
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/{id}", method = RequestMethod.PUT)
    public String updateTaskJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, @RequestBody TaskUnit taskUnit) throws Exception {

        log.info("update task : task= ");

        Task task = taskUnit.getTask();
        String taskName = task.getTaskName();
        Integer taskType = task.getTaskType();
        Integer specificType = task.getSpecificType();
        Integer showLevel = task.getShowLevel();
        String difficultyLevel = task.getDifficultyLevel();
        List<Unit> unitList = taskUnit.getUnitList();
        List<Answer> answerList = taskUnit.getAnswerList();

        Integer returnCode = AcademyCourseTaskUtil.nullJudge(taskType, specificType, taskName, task.getIsLock(), task.getShareToUnlock(), unitList, answerList);
        if (0 != returnCode) {
            model.addAttribute("code", returnCode);
            return "/common/success";
        }

        Integer returnCode2 = AcademyCourseTaskUtil.judgeDifficultyLevel(taskType, specificType, difficultyLevel, showLevel);
        if (0 != returnCode2) {
            model.addAttribute("code", returnCode2);
            return "/common/success";
        }

        try {

            Long userId = AcademyUserUtil.getUserIdLongValue(request);
            task.setUpdateBy(userId);
            task.setShareToUnlock(task.getShareToUnlock());
            taskService.update(task);

            // 更新 unit 和 answer
            updateUnitJson(task, unitList, userId);
            updateAnswerListJson(task, answerList, userId);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update task error,id is  " + task.getId());
            model.addAttribute("code", -6003);
        }

        return "/common/success";
    }


    public void updateUnitJson(Task task, List<Unit> unitList, Long userId) throws ServiceException, ServiceDaoException {

        List<Long> unitIds = unitService.getUnitIdsByTaskIDOrderBySort(task.getId(), 0, Integer.MAX_VALUE);
        if (CollectionUtils.isNotEmpty(unitIds)) {

            unitService.deleteList(Unit.class, unitIds);
        }

        Long taskId = task.getId();
        int i = 1;
        if (null != unitList && unitList.size() > 0) {

            for (Unit unit : unitList) {
                unit.setUpdateBy(userId);
                unit.setTaskId(taskId);
                unit.setSort(i);
                i++;
            }
            unitService.insertList(unitList);
        }
    }


    public void updateAnswerListJson(Task task, List<Answer> answerList, Long userId) throws ServiceException, ServiceDaoException {

        Long taskId = task.getId();

        //如果是习题类型、则需要更新 answer
        if (Task.exercise_type.equals(task.getTaskType())) {

            List<Long> answerIds = answerService.getAnswerIdsByTaskIdOrderByCreateAt(task.getId(), 0, Integer.MAX_VALUE);

            if (CollectionUtils.isNotEmpty(answerIds)) {
                answerService.deleteList(Answer.class, answerIds);
            }
            for (Answer answer : answerList) {

                answer.getMediaType();

                answer.setTaskId(taskId);
                answer.setCreateBy(userId);
                answer.setUpdateBy(userId);
            }
            answerService.insertList(answerList);
        }
    }


    /**
     * 新增任务
     *
     * @param request
     * @param response
     * @param model
     * @param taskUnit
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task", method = RequestMethod.POST)
    public String addTaskJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @RequestBody TaskUnit taskUnit) throws Exception {

        log.info("update task : task= " + taskUnit);
        Task task = taskUnit.getTask();
        if (null == task) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }

        String taskName = task.getTaskName();
        Integer taskType = task.getTaskType();
        Integer specificType = task.getSpecificType();
        Integer showLevel = task.getShowLevel();
        String difficultyLevel = task.getDifficultyLevel();
        List<Unit> unitList = taskUnit.getUnitList();
        List<Answer> answerList = taskUnit.getAnswerList();


        Integer returnCode = AcademyCourseTaskUtil.nullJudge(taskType, specificType, taskName, task.getIsLock(), task.getShareToUnlock(), unitList, answerList);
        if (0 != returnCode) {
            model.addAttribute("code", returnCode);
            return "/common/success";
        }

        Integer returnCode2 = AcademyCourseTaskUtil.judgeDifficultyLevel(taskType, specificType, difficultyLevel, showLevel);
        if (0 != returnCode2) {
            model.addAttribute("code", returnCode2);
            return "/common/success";
        }

        try {

            // 保存 task
            Long userIdLong = AcademyUserUtil.getUserIdLongValue(request);
            Integer maxSort = getMaxSort(task.getPeriodId());
            task.setSort(maxSort);
            task.setCreateBy(userIdLong);

            Long taskId = taskService.insert(task);
            task.setId(taskId);
            task.setShareToUnlock(task.getShareToUnlock());
            updateUnitJson(task, unitList, userIdLong);
            updateAnswerListJson(task, answerList, userIdLong);


            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add task error ");
            model.addAttribute("code", -1);
        }


        return "/common/success";
    }

    /**
     * 删除任务
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/{id}", method = RequestMethod.DELETE)
    public String deleteTaskJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete task : id= " + id);
        Task task = taskService.getObjectById(id);
        Integer taskType = task.getTaskType();

        try {

            List<Long> unitIds = unitService.getUnitIdsByTaskIDOrderBySort(id, 0, Integer.MAX_VALUE);
            List<Long> answerIds = answerService.getAnswerIdsByTaskIdOrderByCreateAt(id, 0, Integer.MAX_VALUE);


            if (CollectionUtils.isNotEmpty(unitIds)) {
                unitService.deleteList(Unit.class, unitIds);
                log.info("delete units success, which taskId is " + id);
            }

            if (taskType == 2) {
                if (CollectionUtils.isNotEmpty(answerIds)) {
                    answerService.deleteList(Answer.class, answerIds);
                    log.info("delete answers success, which taskId is " + id);
                }
            }

            if (null == task) {
                model.addAttribute("code", 2);
                return "/common/success";
            }

            taskService.delete(id);
            model.addAttribute("code", 1);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" error occured deleting task ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 排序任务
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Task> taskList = taskService
                    .getObjectsByIds(ids);

            int index = 1;
            for (Task task : taskList) {
                task.setSort(index);
                index = index + 1;
            }
            this.taskService.updateList(taskList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort task error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 动态获得url
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/task/url", method = RequestMethod.GET)
    public String getUrl(HttpServletRequest request,
                         HttpServletResponse response, ModelMap model,
                         String path) throws Exception {

        if (path == null) {
            model.addAttribute("code", -8004);
            return "/common/success";
        }

        try {

            String[] urlName = path.split("\\/");
            Map<String, String> url = VideoAndVoiceUtil.getVideoUrl(urlName[urlName.length - 1]);
            String paths = url.get("path");
            String signs = url.get("sign");
            String ts = url.get("t");
            String domain = url.get("domain");
            String urls = domain + paths + "?sign=" + signs + "&t=" + ts;
            model.addAttribute("url", urls);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("sort task error ");
            model.addAttribute("code", -1);
        }

        return "/academy-course-service/task/json/url";
    }

    private Integer getMaxSort(Long periodId) throws ServiceException, ServiceDaoException {

        List<Long> periodIds = new ArrayList<>();
        periodIds.add(periodId);

        Map<String, Object> param = DynamicUtil.getTaskList(null, null, null, null, periodIds, null, null, null, null);
        List<Long> maxs = this.taskService.getIdsByDynamicCondition(
                Task.class, param, 0, Integer.MAX_VALUE);
        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.taskService.getObjectById(maxID).getSort();
            if (DataUtils.isNullOrEmpty(max)) {
                max = 1;
            }
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }


    /**
     * @param id 单元id
     * @Description 上下架任务
     * @Author: TongZhirong
     * @Time 2017/9/17 3:19
     */
    @RequestMapping(value = "/a/u/task/{id}/status/{status}", method = RequestMethod.PUT)
    public String upSubject(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, @PathVariable Integer status) throws Exception {

        log.info("on or down unit: " + id);

        try {
            Task task = taskService.getObjectById(id);

            if (null == task) {
                log.info("task does not exist");
                model.addAttribute("code", -3200);
                return "/common/success";
            } else {
                log.info("task does " + id + "exist ");
            }

            if (!status.equals(Task.status_normal) && !status.equals(Task.status_freeze)) {
                log.info(" param status is not legal ");
                model.addAttribute("code", -3200);
                return "/common/success";
            } else {
                log.info("param status is legal");
            }

            if (Task.status_freeze.equals(status)) {
                // 下架 task
                task.setStatus(status);
                boolean update = taskService.update(task);

                // 如果 该任务存在学习记录、则将该条记录的状态设置为 负面状态
                List<Long> userFavoriteRelationIds = userFavoriteRelationService.getUserFavoriteRelationIdsByTargetIdAndTargetTypeAndTypeAndStatus(id, UserFavoriteRelation.TARGET_TYPE_TASK, UserFavoriteRelation.TYPE_VIEW_RECORD, UserFavoriteRelation.STATUS_ACTIVE, 0, Integer.MAX_VALUE);
                log.info("============ PASSIVE userFavoriteRelationIds  is：" + userFavoriteRelationIds);
                List<UserFavoriteRelation> userFavoriteRelationList = userFavoriteRelationService.getObjectsByIds(userFavoriteRelationIds);

                if (CollectionUtils.isNotEmpty(userFavoriteRelationList)) {
                    for (UserFavoriteRelation relation : userFavoriteRelationList) {

                        relation.setStatus(UserFavoriteRelation.STATUS_PASSIVE);
                    }
                    userFavoriteRelationService.updateList(userFavoriteRelationList);
                }
                log.info("============ userFavoriteRelationIds  passive success：" + userFavoriteRelationIds);

                // 检查该task所属period下是否还有上架的task，若无，则下架该period
                Long periodId = task.getPeriodId();
                Long lessonId = task.getLessonId();
                Long subjectId = task.getSubjectId();

                Period period = periodService.getObjectById(periodId);
                Lesson lesson = lessonService.getObjectById(lessonId);
                Subject subject = subjectService.getObjectById(subjectId);

                String periodIdStr = periodId.toString();
                String lessonIdStr = lessonId.toString();
                String subjectIdStr = subjectId.toString();

                List<Long> periodIdList = new ArrayList<>();
                periodIdList.add(periodId);

                Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, null, null, periodIdList, null, Task.status_normal, null, null);
                List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);

                if (CollectionUtils.isEmpty(taskIds)) {
                    // 下架period
                    period.setStatus(Period.status_freeze);
                    periodService.update(period);

                    // 检查该 period 所属 lesson下是否还有 上架的period
                    Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, lessonIdStr, null, Period.status_normal, null);
                    List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
                    List<Period> periodList = periodService.getObjectsByIds(periodIds);

                    if (CollectionUtils.isEmpty(periodIds)) {
                        //下架lesson
                        lesson.setStatus(Lesson.status_freeze);
                        lessonService.update(lesson);
                        // 检查该 subject 下是否还有 上架的lesson
                        List<Long> subjectIdList = new ArrayList<>();
                        subjectIdList.add(subjectId);
                        Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, subjectIdList, Subject.status_normal, null);
                        List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
                        if (CollectionUtils.isEmpty(lessonIds)) {
                            // 下架 subject
                            subject.setStatus(Subject.status_freeze);
                            subjectService.update(subject);
                        }
                    }
                }
            }

            if (Task.status_normal.equals(status)) {
                task.setStatus(status);
                taskService.update(task);

                // 如果 该任务存在学习记录、则将该条记录的状态设置为 正面状态
                List<Long> userFavoriteRelationIds = userFavoriteRelationService.getUserFavoriteRelationIdsByTargetIdAndTargetTypeAndTypeAndStatus(id, UserFavoriteRelation.TARGET_TYPE_TASK, UserFavoriteRelation.TYPE_VIEW_RECORD, UserFavoriteRelation.STATUS_PASSIVE, 0, Integer.MAX_VALUE);
                log.info("============ ACTIVE userFavoriteRelationIds  is：" + userFavoriteRelationIds);
                List<UserFavoriteRelation> userFavoriteRelationList = userFavoriteRelationService.getObjectsByIds(userFavoriteRelationIds);

                if (CollectionUtils.isNotEmpty(userFavoriteRelationList)) {
                    for (UserFavoriteRelation relation : userFavoriteRelationList) {

                        relation.setStatus(UserFavoriteRelation.STATUS_ACTIVE);
                    }
                    userFavoriteRelationService.updateList(userFavoriteRelationList);
                }

            }

            model.addAttribute("code", 0);
            model.addAttribute("message", "success");

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


    /*
     * @author tongzhirong
     * */
    @RequestMapping(value = "/a/u/task/list", method = RequestMethod.GET)
    public String getTaskListJson(HttpServletRequest request, HttpServletResponse response, Integer page, Integer size, ModelMap model,
                                  String taskName, Integer gradeDept, String subjectName, String lessonName, String periodName, Integer taskType, Integer status, Integer specificType, Integer difficultyLevel) {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            List<Long> subjectIds = new ArrayList<>();
            List<Long> lessonIds = new ArrayList<>();
            List<Long> periodIds = new ArrayList<>();

            if (DataUtils.isNotNullOrEmpty(periodName)) {
                Map<String, Object> periodParam = DynamicUtil.getPeriodList(periodName, null, null, null, null);
                periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
            } else if (DataUtils.isNotNullOrEmpty(lessonName)) {
                Map<String, Object> lessonParam = DynamicUtil.getLessonList(lessonName, null, null, null);
                lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
            } else if (DataUtils.isNotNullOrEmpty(subjectName)) {
                Map<String, Object> subjectParam = DynamicUtil.getSubjectList(subjectName, null, null);
                subjectIds = subjectService.getIdsByDynamicCondition(Subject.class, subjectParam, 0, Integer.MAX_VALUE);
            }

            Map<String, Object> taskParam = DynamicUtil.getTaskList(taskType, taskName, subjectIds, lessonIds, periodIds, gradeDept, status, specificType, difficultyLevel);
            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, start, size);
            List<Task> taskList = taskService.getObjectsByIds(taskIds);

            List<Long> periodIdsR = MyListUtil.getList(Task.class.getDeclaredField("periodId"), taskList);
            List<Long> lessonIdsR = MyListUtil.getList(Task.class.getDeclaredField("lessonId"), taskList);
            List<Long> subjectIdsR = MyListUtil.getList(Task.class.getDeclaredField("subjectId"), taskList);

            List<Period> periodList = periodService.getObjectsByIds(periodIdsR);
            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIdsR);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIdsR);

            Map<Long, String> periodId_alias = MyListUtil.convert2Map(Period.class.getDeclaredField("id"), Period.class.getDeclaredField("periodName"), periodList);
            Map<Long, String> lessonId_alias = MyListUtil.convert2Map(Lesson.class.getDeclaredField("id"), Lesson.class.getDeclaredField("lessonName"), lessonList);
            Map<Long, String> subjectId_alias = MyListUtil.convert2Map(Subject.class.getDeclaredField("id"), Subject.class.getDeclaredField("subjectName"), subjectList);

            // TODO: 2017/9/26 暂时从 service 的方法取出总条数
            List<Long> count = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
            Integer total = count.size();
            log.info("get lesson count is " + total);

            boolean next = false;
            if (taskIds.size() + start + 1 <= total) {
                next = true;
            }
            Integer totalPage = (total - 1) / size + 1;

            model.addAttribute("next", next);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("taskList", taskList);
            model.addAttribute("periodId_alias", periodId_alias);
            model.addAttribute("lessonId_alias", lessonId_alias);
            model.addAttribute("subjectId_alias", subjectId_alias);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get lesson list error,page is  " + start + " , size "
                    + size);
            model.addAttribute("code", -100000);

        }

        return "/academy-course-service/task/json/taskListJson";
    }

}

