package com.ptteng.academy.admin.controller.course;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.course.model.Lesson;
import com.ptteng.academy.course.model.Period;
import com.ptteng.academy.course.model.Subject;
import com.ptteng.academy.course.model.Task;
import com.ptteng.academy.course.service.LessonService;
import com.ptteng.academy.course.service.PeriodService;
import com.ptteng.academy.course.service.SubjectService;
import com.ptteng.academy.course.service.TaskService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Subject  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SubjectController {
    private static final Log log = LogFactory.getLog("subject");

    @Autowired
    private SubjectService subjectService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private PeriodService periodService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private CookieUtil cookieUtil;


    /**
     * 上下架科目
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     * @author tongzhirong
     */

    @RequestMapping(value = "/a/u/subject/{subjectId}/status/{status}", method = RequestMethod.PUT)
    public String updateSubjectStatusJson(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long subjectId, @PathVariable Integer status) throws Exception {


        // 校验 subjectId、status类型
        if (!status.equals(Subject.status_freeze) && !status.equals(Subject.status_normal)) {
            model.addAttribute("code", -5030);
            return "/common/success";
        }

        try {
            Subject subject = subjectService.getObjectById(subjectId);

            if (null == subject) {
                log.info("subject is null ");
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            /*
             检查该科目下是否有上架的专题
            * */
            List<Long> subjectIdList = new ArrayList<>();
            subjectIdList.add(subjectId);
            Map<String, Object> subjectLessonParam = DynamicUtil.getLessonList(null, subjectIdList, Lesson.status_normal, null);
            List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, subjectLessonParam, 0, Integer.MAX_VALUE);
            boolean subjectHasNormalLessons = CollectionUtils.isNotEmpty(lessonIds);

//            下架
            if (Subject.status_freeze.equals(status)) {
//                if (subjectHasNormalLessons) {
//                    // 不能下架
//                    // model.addAttribute("code", 7);
//                   // return "/common/success";
//
//                }

                subject.setStatus(Subject.status_freeze);
                subjectService.update(subject);

            }

            //上架
            if (Subject.status_normal.equals(status)) {
                if (!subjectHasNormalLessons) {
                    // 不能上架
                    model.addAttribute("code", -4001);
                    return "/common/success";
                }
                // 上架
                subject.setStatus(Subject.status_normal);
                subjectService.update(subject);

            }


            model.addAttribute("code", 0);
            model.addAttribute("message", "success");
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            // for test
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 查看详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     * @Author tongzhirong
     */
    @RequestMapping(value = "/a/u/subject/{id}", method = RequestMethod.GET)
    public String getSubjectJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer page, Integer size)
            throws Exception {

        log.info("get data : id= " + id);

        try {
            Subject subject = subjectService.getObjectById(id);

            if (null == subject) {
                log.info("subject is null ");
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            model.addAttribute("code", 0);
            model.addAttribute("subject", subject);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get subject error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/academy-course-service/subject/json/subjectDetailJson";
    }

    /**
     * 编辑科目
     *
     * @param request
     * @param response
     * @param model
     * @param subject
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/subject/{id}", method = RequestMethod.PUT)
    public String updateSubjectJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Subject subject,
                                    //GradeAndClass gradeAndClass,
                                    @PathVariable Long id) throws Exception {

        log.info("update subject : subject= " + subject);

        Subject oldSubject = subjectService.getObjectById(id);

        if (null == oldSubject) {
            log.info("old subject is null ");
            model.addAttribute("code", -5042);
            return "/common/success";
        }

        if (null == subject) {
            log.info(" subject is null ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        String subjectName = subject.getSubjectName();
        String fontColour = subject.getFontColour();
        String frontCoverURL = subject.getFrontCoverURL();
        Integer gradeDept = subject.getGradeDept();
        Integer usedGradeDept = oldSubject.getGradeDept();


        String introText = subject.getIntroText();

        // 非必填 主讲人、科目介绍
        if (DataUtils.isNullOrEmpty(subjectName) || DataUtils.isNullOrEmpty(fontColour)
                || DataUtils.isNullOrEmpty(frontCoverURL) || DataUtils.isNullOrEmpty(gradeDept)) {
            log.info(" necessary field is null ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            // 编辑科目时，检查是否有重名科目
            if (subjectName.equals(oldSubject.getSubjectName())) {
                log.info("subjectName hasn't changed ");

            } else {
                List<Long> subjectIds = subjectService.getSubjectIdsByName(subject.getSubjectName(), 0, Integer.MAX_VALUE);
                if (CollectionUtils.isNotEmpty(subjectIds)) {

                    model.addAttribute("code", -4011);
                    return "/common/success";
                }
            }

            List<Long> subjectIds = new ArrayList<>();
            subjectIds.add(id);

            if (!gradeDept.equals(usedGradeDept)) {
                // 专题
                List<Long> subjectIdList = new ArrayList<>();
                subjectIdList.add(id);
                Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, subjectIdList, null, usedGradeDept);
                List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
                List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);

                // 课程
                Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, id.toString(), null, usedGradeDept);
                List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
                List<Period> periodList = periodService.getObjectsByIds(periodIds);

                // 任务
                Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, subjectIds, null, null, usedGradeDept, null,null,null);
                List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);
                List<Task> taskList = taskService.getObjectsByIds(taskIds);


                if (CollectionUtils.isNotEmpty(lessonList)) {
                    for (Lesson lesson : lessonList) {
                        lesson.setGradeDept(gradeDept);
                    }
                    lessonService.updateList(lessonList);
                }

                if (CollectionUtils.isNotEmpty(periodList)) {
                    for (Period period : periodList) {
                        period.setGradeDept(gradeDept);
                    }
                    periodService.updateList(periodList);
                }

                if (CollectionUtils.isNotEmpty(taskList)) {
                    for (Task task : taskList) {
                        task.setGradeDept(gradeDept);
                    }
                    taskService.updateList(taskList);
                }

            }


            String userIdStr = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            long userId = Long.parseLong(userIdStr);
            subject.setUpdateBy(userId);
            subject.setCreateBy(oldSubject.getCreateBy());
            subject.setCreateAt(oldSubject.getCreateAt());
            subject.setSort(oldSubject.getSort());
            boolean update = subjectService.update(subject);

            model.addAttribute("code", 0);
        } catch (
                Throwable t)

        {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add subject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * 新增科目
     *
     * @param request
     * @param response
     * @param model
     * @param subject
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/subject", method = RequestMethod.POST)
    public String addSubjectJson(HttpServletRequest request, HttpServletResponse response,
                                 ModelMap model, Subject subject) throws Exception {

        log.info("insert subject : subject= " + subject);

        if (null == subject) {
            log.info(" subject is null ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        String subjectName = subject.getSubjectName();
        String fontColour = subject.getFontColour();
        String frontCoverURL = subject.getFrontCoverURL();
        Integer gradeDept = subject.getGradeDept();
        String introText = subject.getIntroText();

        // 非必填 主讲人、科目介绍
        if (DataUtils.isNullOrEmpty(subjectName) || DataUtils.isNullOrEmpty(fontColour)
                || DataUtils.isNullOrEmpty(frontCoverURL) || DataUtils.isNullOrEmpty(gradeDept)) {
            log.info(" necessary field is null ");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            subject.setId(null);
            // 检查是否有重名科目
            Map<String, Object> param = DynamicUtil.getSubjectList(subjectName, gradeDept, null);
            List<Long> subjectIds = subjectService.getIdsByDynamicCondition(Subject.class, param, 0, Integer.MAX_VALUE);
            List<Subject> subjectList = subjectService.getObjectsByIds(subjectIds);

            if (null != subjectList && subjectList.size() > 0) {

                log.info("Already exist subject which subjectName is " + subjectName);
                model.addAttribute("code", -4011);
                return "/common/success";
            }
            subject.setSort(this.getMaxSort());
            String userIdStr = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Long userId = Long.valueOf(userIdStr);

            subject.setCreateBy(userId);
            Long subjectIdInsert = subjectService.insert(subject);
            log.info("subject inserted id is " + subjectIdInsert);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add subject error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 获得科目列表
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     * @autho tongzhirong
     */
    @RequestMapping(value = "/a/u/subject/list", method = RequestMethod.GET)
    public String  getMultiSubjectJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                      String subjectName, Integer gradeDept, Integer status)
            throws Exception {

        List<Long> ids = null;

        try {

            log.info(subjectService);
            Map<String, Object> param = DynamicUtil.getSubjectList(subjectName, gradeDept, status);
            ids = subjectService.getIdsByDynamicCondition(Subject.class, param, 0, Integer.MAX_VALUE);
            List<Long> count = subjectService.getIdsByDynamicCondition(Subject.class, param, 0, Integer.MAX_VALUE);
            if (ids == null) {
                log.info("get subject error and ids is null");
                model.addAttribute("code", 2);
                return "/common/success";
            }
            List<Subject> subjectList = subjectService.getObjectsByIds(ids);

            log.info("get  subject data is " + ids);
            Integer total = count.size();
            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("subjectList", subjectList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get subject error, id is  " + ids);
            model.addAttribute("code", -100000);
        }
        return "/academy-course-service/subject/json/subjectListJson";
    }


    /**
     * 排序科目
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/subject/sort", method = RequestMethod.POST)
    public String sort(HttpServletRequest request,
                       HttpServletResponse response, ModelMap model,
                       @RequestBody List<Long> ids) throws Exception {

        log.info("sort lesson : uids= " + ids);

        try {
            List<Subject> subjectList = subjectService.getObjectsByIds(ids);

            int index = 1;
            for (Subject subject : subjectList) {
                subject.setSort(index);
                index = index + 1;
            }
            this.subjectService.updateList(subjectList);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add bookUnit error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    @RequestMapping(value = "/a/u/subject/{subjectId}", method = RequestMethod.DELETE)
    public String deleteSubjectJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long subjectId)
            throws Exception {

        log.info("delete subject : id= " + subjectId);
        try {
            subjectService.delete(subjectId);

            log.info("add subject success");
            model.addAttribute("code", 0);
            List<Long> subjectIdList = new ArrayList<>();
            subjectIdList.add(subjectId);
            Map<String, Object> lessonParam = DynamicUtil.getLessonList(null, subjectIdList, null, null);
            Map<String, Object> periodParam = DynamicUtil.getPeriodList(null, null, subjectId.toString(), null, null);
            Map<String, Object> taskParam = DynamicUtil.getTaskList(null, null, subjectIdList, null, null, null, null, null, null);

            List<Long> lessonIds = lessonService.getIdsByDynamicCondition(Lesson.class, lessonParam, 0, Integer.MAX_VALUE);
            List<Long> periodIds = periodService.getIdsByDynamicCondition(Period.class, periodParam, 0, Integer.MAX_VALUE);
            List<Long> taskIds = taskService.getIdsByDynamicCondition(Task.class, taskParam, 0, Integer.MAX_VALUE);

//            List<Lesson> lessonList = lessonService.getObjectsByIds(lessonIds);
//            List<Period> periodList = periodService.getObjectsByIds(periodIds);
//            List<Task> taskList = taskService.getObjectsByIds(taskIds);

            if (null != lessonIds && lessonIds.size() > 0) {
                lessonService.deleteList(Lesson.class, lessonIds);
                log.info("successfully delete lessons " + lessonIds + " under SubjectId " + subjectId);
            } else {
                log.info("There are no lessons under SubjectId " + subjectId);
            }


            if (null != periodIds && periodIds.size() > 0) {
                periodService.deleteList(Period.class, periodIds);
                log.info("successfully delete periods " + periodIds + " under SubjectId " + subjectId);
            } else {
                log.info("There are no periods under SubjectId " + subjectId);
            }

            if (null != taskIds && taskIds.size() > 0) {
                taskService.deleteList(Task.class, taskIds);
                log.info("successfully delete taskIds " + taskIds + " under SubjectId " + subjectId);
            } else {
                log.info("There are no tasks under SubjectId " + subjectId);
            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete subject error, id is  " + subjectId);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }

    private Integer getMaxSort() throws ServiceException, ServiceDaoException {

        List<Long> maxs = subjectService.getSubjectIdsOrderBySort(0, Integer.MAX_VALUE);

        Integer max = 0;
        if (CollectionUtils.isEmpty(maxs)) {
            log.info("first order ");

        } else {
            Long maxID = maxs.get(maxs.size() - 1);
            max = this.subjectService.getObjectById(maxID).getSort();
            log.info("quiz max order is " + max);
        }
        return max + 1;
    }


}

