package com.ptteng.academy.admin.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.admin.constant.CooperatorConstant;
import com.ptteng.academy.admin.util.DateUtil;
import com.ptteng.academy.admin.util.DynamicUtil;
import com.ptteng.academy.admin.util.SplitLstUtils;
import com.ptteng.academy.user.model.*;
import com.ptteng.academy.user.service.*;
import com.qding.common.util.DataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 合作方数据统计
 *
 * @author 张庆东
 * @date 2018-03-05
 */
@Controller
public class CooperatorStatisticsController {
    private static final Logger log = LoggerFactory.getLogger(CooperatorStatisticsController.class);

    @Autowired
    private UserService userService;

    @Autowired
    private CooperatorStatisticsService cooperatorStatisticsService;

    @Autowired
    private UserOpenidRelationService userOpenidRelationService;

    @Autowired
    private UserMemberRelationService userMemberRelationService;

//    @Autowired
//    private UserOrderService userOrderService;


    //1.新华美育对接用户相关统计列表
    @RequestMapping(value = "/a/u/xinhuameiyu/user/list", method = RequestMethod.GET)
    public String getXinHuaMeiYuUserList(ModelMap model, HttpServletRequest request, HttpServletResponse response,
                                         String username, String mobile, Integer minOrderNumber, Integer maxOrderNumber,
                                         Double minOrderMoney, Double maxOrderMoney, Integer page, Integer size) {

        log.info("/a/u/xinhuameiyu/user/list GET  the params are username:{},mobile:{},minOrderNumber:{},maxOrderNumber:{},minOrderMoney:{},maxOrderMoney:{},page:{},size:{}"
                , new Object[]{username, mobile, minOrderNumber, maxOrderNumber, minOrderMoney, maxOrderMoney, page, size});

        if (size == null || size <= 0) {
            size = 10;
        }
        if (page == null || page < 1) {
            page = 1;
        }
        int start = (page - 1) * size;

        List<CooperatorUserStatistics> cooperatorUserStatisticsList;
        Map<String, Object> cooperatorUserStatisticsMap;
        Map<String, Object> countParam;
        Map<String, Object> allUserNumberParam;

        List<Long> countTotal;
        List<Long> countAllUser;
        Long total;
        Long allUserNumber;


        try {
            //获取新华美育用户订单列表
            cooperatorUserStatisticsMap = DynamicUtil.getXinHuaMeiYuUserList(username, mobile, minOrderNumber, maxOrderNumber, minOrderMoney, maxOrderMoney, false);
            cooperatorUserStatisticsList = cooperatorStatisticsService.getCooperatorUserStatisticsByDynamicCondition(cooperatorUserStatisticsMap, start, size);
            log.info("the xinhuameiyu user list' size is {}", cooperatorUserStatisticsList.size());

            countParam = DynamicUtil.getXinHuaMeiYuUserList(username, mobile, minOrderNumber, maxOrderNumber, minOrderMoney, maxOrderMoney, true);
            countTotal = userService.getIdsByDynamicCondition(User.class, countParam, 0, Integer.MAX_VALUE);
            total = countTotal.get(0);


            //获取所有新华美育用户数量
            allUserNumberParam = DynamicUtil.getXinHuaMeiYuUserList(null, null, null, null, null, null, true);
            countAllUser = userService.getIdsByDynamicCondition(User.class, allUserNumberParam, 0, Integer.MAX_VALUE);
            allUserNumber = countAllUser.get(0);

            long pageNumber = total % size == 0 ? total / size : total / size + 1;

            if (!cooperatorUserStatisticsList.isEmpty()) {
                log.info("the user status is : {}", cooperatorUserStatisticsList.get(0).getStatus());
            }
            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("allUser", allUserNumber);
            model.addAttribute("cooperatorUserStatisticsList", cooperatorUserStatisticsList);
            model.addAttribute("pageNumber", pageNumber);


        } catch (Throwable t) {
            t.getStackTrace();
            log.error("get xinhuameiyu user list error");
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "cooperator/xinHuaMeiYuUserStatisticsList";
    }

    //2.新华美育对接用户单个统计
    @RequestMapping(value = "/a/u/xinhuameiyu/user/{id}", method = RequestMethod.GET)
    public String getXinHuaMeiYuUser(ModelMap model, HttpServletRequest request, HttpServletResponse response,
                                     @PathVariable Long id, Integer page, Integer size) {
        log.info("/a/u/xinhuameiyu/user/{}  GET  the params are page:{},size:{}", new Object[]{id, page, size});

        if (size == null || size <= 0) {
            size = 10;
        }
        if (page == null || page < 1) {
            page = 1;
        }
        int start = (page - 1) * size;

        User xinHuaMeiYuUser;
        Long xinHuaMeiYuUserRelationId;
        UserOpenidRelation xinHuaMeiYuUserRelation;

        List<Long> userMemberRelationIds;
        List<UserMemberRelation> userMemberRelationList;
        List<CooperatorOrder> cooperatorAllOrderList = new ArrayList<>();


        Map<String, Object> cooperatorUserRelationParams;
        Map<String, Object> cooperatorOrderParams;
        Map<String, Object> countCooperatorOrderParams;


        try {
            xinHuaMeiYuUser = userService.getObjectById(id);
            cooperatorUserRelationParams = DynamicUtil.getXinHuaMeiYuUserRelationIdByUid(id);
            xinHuaMeiYuUserRelationId = userOpenidRelationService.getIdsByDynamicCondition(UserOpenidRelation.class, cooperatorUserRelationParams, 0, Integer.MAX_VALUE).get(0);


            //查看用户表或关系表中是否存在该用户，若同时存在则为新华美育用户
            if (DataUtils.isNullOrEmpty(xinHuaMeiYuUser) || DataUtils.isNullOrEmpty(xinHuaMeiYuUserRelationId)) {
                model.addAttribute("code", -2000);
                log.error("用户不存在,id为:{}", id);
                return "/common/success";
            }


            log.info("the xinHuaMeiYuUserRelationId is {}", xinHuaMeiYuUserRelationId);
            xinHuaMeiYuUserRelation = userOpenidRelationService.getObjectById(xinHuaMeiYuUserRelationId);
            userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUid(id, 0, Integer.MAX_VALUE);
            userMemberRelationList = userMemberRelationService.getObjectsByIds(userMemberRelationIds);
            log.info("get the userMemberRelationList's size is {}", userMemberRelationList.size());


            cooperatorOrderParams = DynamicUtil.getXinHuaMeiYuOrder(id,false);
            cooperatorAllOrderList = cooperatorStatisticsService.getCooperatorOrdersByDynamicCondition(cooperatorOrderParams, start, size);
            countCooperatorOrderParams = DynamicUtil.getXinHuaMeiYuOrder(id, true);
            Long total = userService.getIdsByDynamicCondition(UserOrder.class, countCooperatorOrderParams, 0, Integer.MAX_VALUE).get(0);


            long pageNumber = total % size == 0 ? total / size : total / size + 1;
            log.info("total:{},size:{},pageNumber:{}", new Object[]{total, size, pageNumber});

            model.addAttribute("user", xinHuaMeiYuUser);
            model.addAttribute("cooperatorAllOrderList", cooperatorAllOrderList);
            model.addAttribute("code", 0);
            model.addAttribute("userRelation", xinHuaMeiYuUserRelation);
            model.addAttribute("total", total);
            model.addAttribute("pageNumber", pageNumber);
        } catch (Throwable t) {
            t.getStackTrace();
            log.error(t.getMessage());
            log.error("get single xinhuameiyu user error ,the id is {}", id);
            model.addAttribute("code", -100000);
        }
        return "cooperator/xinHuaMeiYuUserStatisticsDetail";
    }

    //3.新华美育订单统计列表
    @RequestMapping(value = "/a/u/xinhuameiyu/order/list", method = RequestMethod.GET)
    public String getXinHuaMeiYuOrderList(ModelMap model, HttpServletRequest request, HttpServletResponse response,
                                          Long startAt, Long endAt, Integer page, Integer size) {
        log.info("/a/u/xinhuameiyu/order/list GET,the params are startAt:{},endAt:{},page:{},size:{}", new Object[]{startAt, endAt, page, size});

        if (size == null || size <= 0) {
            size = 10;
        }
        if (page == null || page < 1) {
            page = 1;
        }

        if (DataUtils.isNullOrEmpty(endAt)) {
            endAt = System.currentTimeMillis();
        }

        //若开始时间为空或其小于逗你学-新华美育对接时间，则设置为新华美育对接时间
        if (DataUtils.isNullOrEmpty(startAt) || CooperatorConstant.COOPERATOR_LINK_START_TIME > startAt) {
            startAt = CooperatorConstant.COOPERATOR_LINK_START_TIME;
        }

        Map<String, Object> cooperatorDateOrderParamsMap;

        List<CooperatorOrder> cooperatorOrderList;

        //对开始时间、结束时间进行格式化
        startAt = DateUtil.getTimeInMillisDayStart(startAt);
        endAt = DateUtil.getTimeInMillisDayStart(endAt);
        log.info("the real startAt:{},endAt:{}", startAt, endAt);

        Integer total = (int) ((endAt - startAt) / 86400000L) + 1;

        try {
            startAt = DateUtil.getTimeInMillisDayStart(startAt);
            endAt = DateUtil.getTimeInMillisDayEnd(endAt);

            //获取日期订单列表
            cooperatorDateOrderParamsMap = DynamicUtil.getXinHuaMeiYuDateOrder(startAt, endAt, page, size);
            cooperatorOrderList = cooperatorStatisticsService.getCooperatorOrdersByDynamicCondition(cooperatorDateOrderParamsMap, 0, Integer.MAX_VALUE);

            //获取专题、会员该段时间数量
            Integer subjectAllOrderNumber = cooperatorStatisticsService.getLessonOrderNumber(CooperatorConstant.COOPERATOR_LINK_START_TIME, startAt, endAt);
            Integer memberAllOrderNumber = cooperatorStatisticsService.getMemberOrderNumber(CooperatorConstant.COOPERATOR_LINK_START_TIME, startAt, endAt);

            //获取专题、会员该段时间总金额
            Double subjectAllOrderMoney = cooperatorStatisticsService.getLessonOrderMoney(CooperatorConstant.COOPERATOR_LINK_START_TIME, startAt, endAt);
            Double memberAllOrderMoney = cooperatorStatisticsService.getMemberOrderMoney(CooperatorConstant.COOPERATOR_LINK_START_TIME, startAt, endAt);

            Integer totalTrades = subjectAllOrderNumber + memberAllOrderNumber;
            log.info("the subjectAllOrderMoney:{},memberAllOrderMoney:{}", subjectAllOrderMoney, memberAllOrderMoney);
            Double totalTradesMoney = subjectAllOrderMoney + memberAllOrderMoney;
            String roundTotalTradesMoney = String.format("%.2f", totalTradesMoney);

            long pageNumber = total % size == 0 ? total / size : total / size + 1;

            model.addAttribute("cooperatorOrderList", cooperatorOrderList);
            model.addAttribute("totalTrades", totalTrades);
            model.addAttribute("totalTradesMoney", roundTotalTradesMoney);
            model.addAttribute("code", 0);
            model.addAttribute("total", total);
            model.addAttribute("pageNumber", pageNumber);

        } catch (Throwable t) {
            t.getStackTrace();
            log.error(t.getMessage());
            log.error("get xinhuameiyu order list error ");
            model.addAttribute("code", -100000);
        }


        return "cooperator/xinHuaMeiYuOrderStatisticsList";
    }


    //4.新华美育单日订单统计
    @RequestMapping(value = "/a/u/xinhuameiyu/order/{orderTime}", method = RequestMethod.GET)
    public String getXinHuaMeiYuOrderList(ModelMap model, HttpServletRequest request, HttpServletResponse response,
                                          @PathVariable Long orderTime, Integer page, Integer size) {
        log.info("/a/u/xinhuameiyu/order/{} GET the params are page:{},size:{} ", new Object[]{orderTime, page, size});

        if (size == null || size <= 0) {
            size = 10;
        }
        if (page == null || page < 1) {
            page = 1;
        }

        int start = (page - 1) * size;

        Long orderTimeStart = DateUtil.getTimeInMillisDayStart(orderTime);
        Long orderTimeEnd = DateUtil.getTimeInMillisDayEnd(orderTime);

        List<CooperatorOrder> finalDateOderList = new ArrayList<>();

        try {
            //获取该新华美育用户订单列表
            finalDateOderList = cooperatorStatisticsService.getDateCooperatorOrder(orderTimeStart, orderTimeEnd, start, size);
            Integer total = cooperatorStatisticsService.countDateCooperatorOrder(orderTimeStart, orderTimeEnd);

            long pageNumber = total % size == 0 ? total / size : total / size + 1;

            model.addAttribute("total", total);
            model.addAttribute("code", 0);
            model.addAttribute("pageNumber", pageNumber);
            model.addAttribute("finalDateOderList", finalDateOderList);

        } catch (Throwable t) {
            t.getStackTrace();
            log.error(t.getMessage());
            log.error("get xinhuameiyu  single date order error ,the time stamp is :{}", orderTime);
            model.addAttribute("code", -100000);
        }
        return "cooperator/xinHuaMeiYuOderStatisticsDetail";
    }


}
