/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.annotations.NotNull;
import pl.project13.maven.git.GitDataProvider;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.log.LoggerBridge;

public class NativeGitProvider
extends GitDataProvider {
    private transient CliRunner runner;
    private String dateFormat;
    File dotGitDirectory;
    File canonical;
    private static final int REMOTE_COLS = 3;

    private NativeGitProvider(CliRunner runner, String dateFormat) {
        this.runner = runner;
        this.dateFormat = dateFormat;
    }

    @NotNull
    public static NativeGitProvider on(@NotNull File dotGitDirectory) {
        return new NativeGitProvider(dotGitDirectory);
    }

    NativeGitProvider(@NotNull File dotGitDirectory) {
        this.dotGitDirectory = dotGitDirectory;
    }

    @NotNull
    public NativeGitProvider withLoggerBridge(LoggerBridge bridge) {
        this.loggerBridge = bridge;
        return this;
    }

    @NotNull
    public NativeGitProvider setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.loggerBridge.setVerbose(verbose);
        return this;
    }

    public NativeGitProvider setPrefixDot(String prefixDot) {
        this.prefixDot = prefixDot;
        return this;
    }

    public NativeGitProvider setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
        return this;
    }

    public NativeGitProvider setDateFormat(String dateFormat) {
        ((GitDataProvider)this).dateFormat = dateFormat;
        return this;
    }

    public NativeGitProvider setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
        return this;
    }

    @Override
    protected void init() throws MojoExecutionException {
        try {
            this.canonical = this.dotGitDirectory.getCanonicalFile();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Passed a invalid directory, not a GIT repository: " + this.dotGitDirectory, ex);
        }
    }

    @Override
    protected String getBuildAuthorName() {
        return this.tryToRunGitCommand(this.canonical, "log -1 --pretty=format:\"%an\"");
    }

    @Override
    protected String getBuildAuthorEmail() {
        return this.tryToRunGitCommand(this.canonical, "log -1 --pretty=format:\"%ae\"");
    }

    @Override
    protected void prepareGitToExtractMoreDetailedReproInformation() throws MojoExecutionException {
    }

    @Override
    protected String getBranchName() throws IOException {
        return this.getBranch(this.canonical);
    }

    private String getBranch(File canonical) {
        String branch = this.tryToRunGitCommand(canonical, "symbolic-ref HEAD");
        if (branch != null) {
            branch = branch.replace("refs/heads/", "");
        }
        return branch;
    }

    @Override
    protected String getGitDescribe() throws MojoExecutionException {
        String argumentsForGitDescribe = this.getArgumentsForGitDescribe(this.gitDescribe);
        String gitDescribe = this.tryToRunGitCommand(this.canonical, "describe " + argumentsForGitDescribe);
        return gitDescribe;
    }

    private String getArgumentsForGitDescribe(GitDescribeConfig gitDescribe) {
        if (gitDescribe != null) {
            return this.getArgumentsForGitDescribeAndDescibeNotNull(gitDescribe);
        }
        return "";
    }

    private String getArgumentsForGitDescribeAndDescibeNotNull(GitDescribeConfig gitDescribe) {
        String dirtyMark;
        StringBuilder argumentsForGitDescribe = new StringBuilder();
        if (gitDescribe.isAlways()) {
            argumentsForGitDescribe.append("--always ");
        }
        if ((dirtyMark = gitDescribe.getDirty()) != null && !dirtyMark.isEmpty()) {
            argumentsForGitDescribe.append("--dirty=" + dirtyMark + " ");
        }
        argumentsForGitDescribe.append("--abbrev=" + gitDescribe.getAbbrev() + " ");
        if (gitDescribe.getTags()) {
            argumentsForGitDescribe.append("--tags ");
        }
        if (gitDescribe.getForceLongFormat()) {
            argumentsForGitDescribe.append("--long ");
        }
        return argumentsForGitDescribe.toString();
    }

    @Override
    protected String getCommitId() {
        return this.tryToRunGitCommand(this.canonical, "rev-parse HEAD");
    }

    @Override
    protected String getAbbrevCommitId() throws MojoExecutionException {
        String commitId = this.getCommitId();
        String abbrevCommitId = "";
        if (commitId != null && !commitId.isEmpty()) {
            abbrevCommitId = commitId.substring(0, this.abbrevLength);
        }
        return abbrevCommitId;
    }

    @Override
    protected String getCommitAuthorName() {
        return this.tryToRunGitCommand(this.canonical, "log -1 --pretty=format:\"%cn\"");
    }

    @Override
    protected String getCommitAuthorEmail() {
        return this.tryToRunGitCommand(this.canonical, "log -1 --pretty=format:\"%ce\"");
    }

    @Override
    protected String getCommitMessageFull() {
        return this.tryToRunGitCommand(this.canonical, "log -1 --pretty=format:\"%B\"");
    }

    @Override
    protected String getCommitMessageShort() {
        return this.tryToRunGitCommand(this.canonical, "log -1 --pretty=format:\"%s\"");
    }

    @Override
    protected String getCommitTime() {
        return this.tryToRunGitCommand(this.canonical, "log -1 --pretty=format:\"%ci\"");
    }

    @Override
    protected String getTags() throws MojoExecutionException {
        final String branch = this.tryToRunGitCommand(this.canonical, "rev-parse --abbrev-ref HEAD");
        String out = this.tryToRunGitCommand(this.canonical, "log -n 1 --pretty=format:'%d'");
        String[] nms = out.replaceAll("HEAD", "").replaceAll("\\)", "").replaceAll("\\(", "").replaceAll("'", "").replaceAll("tag: ", "").replaceAll(",", "").trim().split(" ");
        ImmutableList cleanTags = FluentIterable.from(Arrays.asList(nms)).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.trim();
            }
        }).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.equals(branch);
            }
        }).toList();
        return Joiner.on((String)",").join((Iterable)cleanTags);
    }

    @Override
    protected String getRemoteOriginUrl() throws MojoExecutionException {
        return this.getOriginRemote(this.canonical);
    }

    @Override
    protected void finalCleanUp() {
    }

    private String getOriginRemote(File directory) throws MojoExecutionException {
        String remoteUrl = null;
        try {
            String remotes = this.runGitCommand(directory, "remote -v");
            for (String line : Splitter.onPattern((String)"\\((fetch|push)\\)?").split((CharSequence)remotes)) {
                String trimmed = line.trim();
                if (!trimmed.startsWith("origin")) continue;
                String[] splited = trimmed.split("\\s+");
                if (splited.length != 2) {
                    throw new MojoExecutionException("Unsupported GIT output (verbose remote address): " + line);
                }
                remoteUrl = splited[1];
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while obtaining origin remote", e);
        }
        return remoteUrl;
    }

    private String tryToRunGitCommand(File directory, String gitCommand) {
        String retValue = "";
        try {
            retValue = this.runGitCommand(directory, gitCommand);
        }
        catch (MojoExecutionException ex) {
            // empty catch block
        }
        return retValue;
    }

    private String runGitCommand(File directory, String gitCommand) throws MojoExecutionException {
        try {
            String env = System.getenv("GIT_PATH");
            String exec = env == null ? "git" : env;
            String command = String.format("%s %s", exec, gitCommand);
            String result = this.getRunner().run(directory, command).trim();
            return result;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not run GIT command - GIT is not installed or not exists in system path? Tried to run: 'git " + gitCommand + "'", (Exception)ex);
        }
    }

    private CliRunner getRunner() {
        if (this.runner == null) {
            this.runner = new Runner();
        }
        return this.runner;
    }

    protected static class Runner
    implements CliRunner {
        protected Runner() {
        }

        @Override
        public String run(File directory, String command) throws IOException {
            String output = "";
            try {
                String line;
                ProcessBuilder builder = new ProcessBuilder(command.split("\\s"));
                Process proc = builder.directory(directory).start();
                proc.waitFor();
                InputStream is = proc.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                StringBuilder commandResult = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    commandResult.append(line);
                }
                if (proc.exitValue() != 0) {
                    String message = String.format("Git command exited with invalid status [%d]: `%s`", proc.exitValue(), output);
                    throw new IOException(message);
                }
                output = commandResult.toString();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            return output;
        }
    }

    public static interface CliRunner {
        public String run(File var1, String var2) throws IOException;
    }
}

