/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.maven;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.zeroturnaround.javarebel.maven.model.RebelClasspathResource;
import org.zeroturnaround.javarebel.maven.model.RebelResource;
import org.zeroturnaround.javarebel.maven.model.RebelWar;
import org.zeroturnaround.javarebel.maven.model.RebelWebResource;

class RebelXmlBuilder {
    private String fallbackClasspath;
    private final String mavenVersion;
    private final String pluginVersion;
    private final List classpathDir = new ArrayList();
    private final List classpathJar = new ArrayList();
    private final List classpathJarset = new ArrayList();
    private final List classpathDirset = new ArrayList();
    private RebelWar war;
    private List webResources = new ArrayList();

    public RebelXmlBuilder(String mavenVersion, String pluginVersion) {
        this.mavenVersion = mavenVersion;
        this.pluginVersion = pluginVersion;
    }

    public void setFallbackClasspath(String fallbackClasspath) {
        this.fallbackClasspath = fallbackClasspath;
    }

    public void addClasspathDir(RebelClasspathResource dir) {
        this.classpathDir.add(dir);
    }

    public void addClasspathJar(RebelClasspathResource jar) {
        this.classpathJar.add(jar);
    }

    public void addClasspathJarset(RebelClasspathResource jarset) {
        this.classpathJarset.add(jarset);
    }

    public void addClasspathDirset(RebelClasspathResource dirset) {
        this.classpathDirset.add(dirset);
    }

    public void setWar(RebelWar war) {
        this.war = war;
    }

    public void addWebresource(RebelWebResource webResource) {
        this.webResources.add(webResource);
    }

    public void writeXml(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("\n<!--\n  This is the JRebel configuration file. It maps the running application to your IDE workspace, enabling JRebel reloading for this project.\n  Refer to https://manuals.zeroturnaround.com/jrebel/standalone/config.html for more information.\n-->\n<application generated-by=\"maven\" build-tool-version=\"" + StringEscapeUtils.escapeXml((String)this.mavenVersion) + "\" plugin-version=\"" + StringEscapeUtils.escapeXml((String)this.pluginVersion) + "\" " + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.zeroturnaround.com\" " + "xsi:schemaLocation=\"http://www.zeroturnaround.com http://update.zeroturnaround.com/jrebel/rebel-2_2.xsd\">\n");
        writer.write("\t<classpath");
        if (this.fallbackClasspath != null) {
            writer.write(" fallback=\"" + this.fallbackClasspath + "\"");
        }
        writer.write(">\n");
        for (RebelResource r : this.classpathDir) {
            writer.write("\t\t<dir name=\"" + StringEscapeUtils.escapeXml((String)((RebelClasspathResource)r).getDirectory()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</dir>\n");
        }
        for (RebelResource r : this.classpathJar) {
            writer.write("\t\t<jar name=\"" + StringEscapeUtils.escapeXml((String)((RebelClasspathResource)r).getJar()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</jar>\n");
        }
        for (RebelResource r : this.classpathJarset) {
            writer.write("\t\t<jarset dir=\"" + StringEscapeUtils.escapeXml((String)((RebelClasspathResource)r).getJarset()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</jarset>\n");
        }
        for (RebelResource r : this.classpathDirset) {
            writer.write("\t\t<dirset dir=\"" + StringEscapeUtils.escapeXml((String)((RebelClasspathResource)r).getDirset()) + "\">\n");
            this.writeExcludeInclude(writer, (RebelClasspathResource)r);
            writer.write("\t\t</dirset>\n");
        }
        writer.write("\t</classpath>\n");
        writer.write("\n");
        if (this.war != null && this.war.getPath() != null) {
            writer.write("\t<war dir=\"" + StringEscapeUtils.escapeXml((String)this.war.getPath()) + "\"/>\n");
            writer.write("\n");
        }
        if (this.webResources.size() > 0) {
            writer.write("\t<web>\n");
            for (RebelResource r : this.webResources) {
                if (!((RebelWebResource)r).doesDirExistsOrNotAbsolute()) continue;
                writer.write("\t\t<link target=\"" + StringEscapeUtils.escapeXml((String)((RebelWebResource)r).getTarget()) + "\">\n");
                writer.write("\t\t\t<dir name=\"" + StringEscapeUtils.escapeXml((String)((RebelWebResource)r).getDirectory()) + "\">\n");
                this.writeExcludeInclude(writer, (RebelWebResource)r);
                writer.write("\t\t\t</dir>\n");
                writer.write("\t\t</link>\n");
            }
            writer.write("\t</web>\n");
            writer.write("\n");
        }
        writer.write("</application>\n");
        writer.flush();
    }

    private void writeExcludeInclude(Writer writer, RebelClasspathResource r) throws IOException {
        this.writeExcludeInclude(writer, r, 3);
    }

    private void writeExcludeInclude(Writer writer, RebelWebResource r) throws IOException {
        this.writeExcludeInclude(writer, r, 4);
    }

    private void writeExcludeInclude(Writer writer, RebelResource r, int indent) throws IOException {
        String indention = StringUtils.repeat((String)"\t", (int)indent);
        if (r.getExcludes() != null) {
            for (String exclude : r.getExcludes()) {
                writer.write(indention + "<exclude name=\"" + StringEscapeUtils.escapeXml((String)exclude) + "\"/>\n");
            }
        }
        if (r.getIncludes() != null) {
            for (String include : r.getIncludes()) {
                writer.write(indention + "<include name=\"" + StringEscapeUtils.escapeXml((String)include) + "\"/>\n");
            }
        }
    }
}

