/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.managed.ManagedContainerConfiguration;
import org.jboss.as.arquillian.container.managed.PortAcquisitionTimeoutException;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.core.launcher.StandaloneCommandBuilder;

public final class ManagedDeployableContainer
extends CommonDeployableContainer<ManagedContainerConfiguration> {
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    static final String CONFIG_DIR = "configuration";
    static final String DATA_DIR = "data";
    private static final int PORT_RANGE_MIN = 1;
    private static final int PORT_RANGE_MAX = 65535;
    private final Logger log = Logger.getLogger(ManagedDeployableContainer.class.getName());
    private Thread shutdownThread;
    private Process process;
    private boolean timeoutSupported = false;

    public Class<ManagedContainerConfiguration> getConfigurationClass() {
        return ManagedContainerConfiguration.class;
    }

    protected void startInternal() throws LifecycleException {
        ManagedContainerConfiguration config = (ManagedContainerConfiguration)this.getContainerConfiguration();
        if (this.isServerRunning()) {
            if (config.isAllowConnectingToRunningServer()) {
                return;
            }
            this.failDueToRunning();
        }
        try {
            String bundlesPath;
            StandaloneCommandBuilder commandBuilder = StandaloneCommandBuilder.of((String)config.getJbossHome());
            String modulesPath = config.getModulePath();
            if (modulesPath != null && !modulesPath.isEmpty()) {
                commandBuilder.addModuleDirs(modulesPath.split(Pattern.quote(File.pathSeparator)));
            }
            if ((bundlesPath = config.getBundlePath()) == null || !bundlesPath.isEmpty()) {
                this.log.warning("Bundles path is deprecated and no longer used.");
            }
            String javaOpts = config.getJavaVmArguments();
            String jbossArguments = config.getJbossArguments();
            commandBuilder.setJavaHome(config.getJavaHome());
            if (javaOpts != null) {
                commandBuilder.setJavaOptions(javaOpts.split("\\s+"));
            }
            if (config.isEnableAssertions()) {
                commandBuilder.addJavaOption("-ea");
            }
            if (config.isSetupCleanServerBaseDir() || config.getCleanServerBaseDir() != null) {
                ManagedDeployableContainer.setupCleanServerDirectories(commandBuilder, config.getCleanServerBaseDir());
            }
            if (config.isAdminOnly()) {
                commandBuilder.setAdminOnly();
            }
            if (jbossArguments != null) {
                commandBuilder.addServerArguments(jbossArguments.split("\\s+"));
            }
            if (config.getServerConfig() != null) {
                commandBuilder.setServerConfiguration(config.getServerConfig());
            }
            commandBuilder.addJavaOption("-Djboss.home.dir=" + commandBuilder.getWildFlyHome());
            this.waitOnPorts();
            this.log.info("Starting container with: " + commandBuilder.build());
            this.process = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true).launch();
            new Thread(new ConsoleConsumer()).start();
            this.shutdownThread = ProcessHelper.addShutdownHook((Process)this.process);
            long startupTimeout = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            long sleep = 1000L;
            while (timeout > 0L && !serverAvailable) {
                long before = System.currentTimeMillis();
                serverAvailable = this.getManagementClient().isServerInRunningState();
                timeout -= System.currentTimeMillis() - before;
                if (serverAvailable) continue;
                if (ProcessHelper.processHasDied((Process)this.process)) {
                    String msg = String.format("The java process starting the managed server exited unexpectedly with code [%d]", this.process.exitValue());
                    throw new LifecycleException(msg);
                }
                Thread.sleep(sleep);
                timeout -= sleep;
                sleep = Math.max(sleep / 2L, 100L);
            }
            if (!serverAvailable) {
                ProcessHelper.destroyProcess((Process)this.process);
                throw new TimeoutException(String.format("Managed server was not started within [%d] s", ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds()));
            }
            this.timeoutSupported = this.isOperationAttributeSupported("shutdown", "timeout");
        }
        catch (LifecycleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    private void waitOnPorts() throws PortAcquisitionTimeoutException {
        Integer[] ports = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getWaitForPorts();
        int timeoutInSeconds = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getWaitForPortsTimeoutInSeconds();
        if (ports != null && ports.length > 0) {
            for (int i = 0; i < ports.length; ++i) {
                int port = ports[i];
                long start = System.currentTimeMillis();
                while (!this.isPortAvailable(port)) {
                    int elapsedSeconds = (int)((System.currentTimeMillis() - start) / 1000L);
                    if (elapsedSeconds > timeoutInSeconds) {
                        throw new PortAcquisitionTimeoutException(port, timeoutInSeconds);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    this.log.warning("Waiting on port " + port + " to become available for " + (timeoutInSeconds - elapsedSeconds) + "s");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortAvailable(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port specified is out of range: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ds = new DatagramSocket(port);
            ss.setReuseAddress(true);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    protected void stopInternal(Integer timeout) throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                Thread shutdown = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(((ManagedContainerConfiguration)ManagedDeployableContainer.this.getContainerConfiguration()).getStopTimeoutInSeconds() * 1000);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (ManagedDeployableContainer.this.process != null) {
                            ManagedDeployableContainer.this.process.destroy();
                        }
                    }
                });
                shutdown.start();
                ModelNode op = Operations.createOperation((String)"shutdown");
                if (this.timeoutSupported) {
                    if (timeout != null) {
                        op.get("timeout").set(timeout.intValue());
                    }
                } else {
                    this.log.severe(String.format("Timeout is not supported for %s on the shutdown operation.", this.getContainerDescription()));
                }
                this.getManagementClient().getControllerClient().executeAsync(op, null);
                this.process.waitFor();
                this.process = null;
                shutdown.interrupt();
            }
        }
        catch (Exception e) {
            try {
                ProcessHelper.destroyProcess((Process)this.process);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning() {
        Socket socket = null;
        try {
            socket = new Socket(((ManagedContainerConfiguration)this.getContainerConfiguration()).getManagementAddress(), ((ManagedContainerConfiguration)this.getContainerConfiguration()).getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning() throws LifecycleException {
        throw new LifecycleException("The server is already running! Managed containers do not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
    }

    private static void setupCleanServerDirectories(StandaloneCommandBuilder commandBuilder, String cleanServerBaseDirPath) throws IOException {
        Path cleanBase = cleanServerBaseDirPath != null ? Paths.get(cleanServerBaseDirPath, new String[0]) : Files.createTempDirectory(TEMP_CONTAINER_DIRECTORY, new FileAttribute[0]);
        if (Files.notExists(cleanBase, new LinkOption[0])) {
            throw ServerLogger.ROOT_LOGGER.serverBaseDirectoryDoesNotExist(cleanBase.toFile());
        }
        if (!Files.isDirectory(cleanBase, new LinkOption[0])) {
            throw ServerLogger.ROOT_LOGGER.serverBaseDirectoryIsNotADirectory(cleanBase.toFile());
        }
        Path currentConfigDir = commandBuilder.getConfigurationDirectory();
        Path configDir = cleanBase.resolve(CONFIG_DIR);
        ManagedDeployableContainer.copyDir(currentConfigDir, configDir);
        Path currentDataDir = commandBuilder.getBaseDirectory().resolve(DATA_DIR);
        if (Files.exists(currentDataDir, new LinkOption[0])) {
            ManagedDeployableContainer.copyDir(currentDataDir, cleanBase.resolve(DATA_DIR));
        }
        commandBuilder.setBaseDirectory(cleanBase);
        commandBuilder.setConfigurationDirectory(configDir);
    }

    private static void copyDir(final Path from, final Path to) throws IOException {
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.copy(dir, to.resolve(from.relativize(dir)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, to.resolve(from.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = ManagedDeployableContainer.this.process.getInputStream();
            boolean writeOutput = ((ManagedContainerConfiguration)ManagedDeployableContainer.this.getContainerConfiguration()).isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

