/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.util;

import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.View;
import org.thymeleaf.util.ContentTypeUtils;

public final class SpringContentTypeUtils {
    public static String computeViewContentType(HttpServletRequest request, String defaultContentType, Charset defaultCharset) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        MediaType negotiatedMediaType = (MediaType)request.getAttribute(View.SELECTED_CONTENT_TYPE);
        if (negotiatedMediaType != null && negotiatedMediaType.isConcrete()) {
            Charset negotiatedCharset = negotiatedMediaType.getCharSet();
            if (negotiatedCharset != null) {
                return negotiatedMediaType.toString();
            }
            return ContentTypeUtils.combineContentTypeAndCharset((String)negotiatedMediaType.toString(), (Charset)defaultCharset);
        }
        String combinedContentType = ContentTypeUtils.combineContentTypeAndCharset((String)defaultContentType, (Charset)defaultCharset);
        Charset combinedCharset = ContentTypeUtils.computeCharsetFromContentType((String)combinedContentType);
        String requestPathContentType = ContentTypeUtils.computeContentTypeForRequestPath((String)request.getRequestURI(), (Charset)combinedCharset);
        if (requestPathContentType != null) {
            return requestPathContentType;
        }
        return combinedContentType;
    }

    private SpringContentTypeUtils() {
    }
}

