/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.lang.reflect.Modifier;
import java.util.List;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.MethodProvider;

public class DynamicLookup {
    private String name;
    private String methodDescriptor;

    public DynamicLookup(String name, String methodDescriptor) {
        this.name = name;
        this.methodDescriptor = methodDescriptor;
    }

    public Invoker lookup(MethodProvider methodProvider) {
        List<Invoker> methods = methodProvider.getDeclaredMethods();
        for (Invoker invoker : methods) {
            if (!this.matches(invoker)) continue;
            return invoker;
        }
        MethodProvider parent = methodProvider.getSuper();
        if (parent != null) {
            return this.lookup(parent);
        }
        return null;
    }

    protected boolean matches(Invoker invoker) {
        return !Modifier.isPrivate(invoker.getModifiers()) && this.name.equals(invoker.getName()) && this.methodDescriptor.equals(invoker.getMethodDescriptor());
    }
}

