/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.handler.AbstractDetectingUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.annotation.ServletAnnotationMappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationHandlerMapping
extends AbstractDetectingUrlHandlerMapping {
    static final String USE_DEFAULT_SUFFIX_PATTERN = String.valueOf(DefaultAnnotationHandlerMapping.class.getName()) + ".useDefaultSuffixPattern";
    private boolean useDefaultSuffixPattern = true;
    private final Map<Class<?>, RequestMapping> cachedMappings = new HashMap();

    public void setUseDefaultSuffixPattern(boolean useDefaultSuffixPattern) {
        this.useDefaultSuffixPattern = useDefaultSuffixPattern;
    }

    @Override
    protected String[] determineUrlsForHandler(String beanName) {
        ApplicationContext context = this.getApplicationContext();
        Class handlerType = context.getType(beanName);
        RequestMapping mapping = (RequestMapping)context.findAnnotationOnBean(beanName, RequestMapping.class);
        if (mapping != null) {
            this.cachedMappings.put(handlerType, mapping);
            LinkedHashSet<String> urls = new LinkedHashSet<String>();
            String[] typeLevelPatterns = mapping.value();
            if (typeLevelPatterns.length > 0) {
                String[] methodLevelPatterns = this.determineUrlsForHandlerMethods(handlerType, true);
                String[] stringArray = typeLevelPatterns;
                int n = typeLevelPatterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String typeLevelPattern = stringArray[n2];
                    if (!typeLevelPattern.startsWith("/")) {
                        typeLevelPattern = "/" + typeLevelPattern;
                    }
                    boolean hasEmptyMethodLevelMappings = false;
                    String[] stringArray2 = methodLevelPatterns;
                    int n3 = methodLevelPatterns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String methodLevelPattern = stringArray2[n4];
                        if (methodLevelPattern == null) {
                            hasEmptyMethodLevelMappings = true;
                        } else {
                            String combinedPattern = this.getPathMatcher().combine(typeLevelPattern, methodLevelPattern);
                            this.addUrlsForPath(urls, combinedPattern);
                        }
                        ++n4;
                    }
                    if (hasEmptyMethodLevelMappings || Controller.class.isAssignableFrom(handlerType)) {
                        this.addUrlsForPath(urls, typeLevelPattern);
                    }
                    ++n2;
                }
                return StringUtils.toStringArray(urls);
            }
            return this.determineUrlsForHandlerMethods(handlerType, false);
        }
        if (AnnotationUtils.findAnnotation((Class)handlerType, org.springframework.stereotype.Controller.class) != null) {
            return this.determineUrlsForHandlerMethods(handlerType, false);
        }
        return null;
    }

    protected String[] determineUrlsForHandlerMethods(Class<?> handlerType, final boolean hasTypeLevelMapping) {
        String[] subclassResult = this.determineUrlsForHandlerMethods(handlerType);
        if (subclassResult != null) {
            return subclassResult;
        }
        final LinkedHashSet urls = new LinkedHashSet();
        LinkedHashSet handlerTypes = new LinkedHashSet();
        handlerTypes.add(handlerType);
        handlerTypes.addAll((Collection)Arrays.asList(handlerType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    RequestMapping mapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                    if (mapping != null) {
                        String[] mappedPatterns = mapping.value();
                        if (mappedPatterns.length > 0) {
                            String[] stringArray = mappedPatterns;
                            int n = mappedPatterns.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String mappedPattern = stringArray[n2];
                                if (!hasTypeLevelMapping && !mappedPattern.startsWith("/")) {
                                    mappedPattern = "/" + mappedPattern;
                                }
                                DefaultAnnotationHandlerMapping.this.addUrlsForPath(urls, mappedPattern);
                                ++n2;
                            }
                        } else if (hasTypeLevelMapping) {
                            urls.add(null);
                        }
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return StringUtils.toStringArray(urls);
    }

    protected String[] determineUrlsForHandlerMethods(Class<?> handlerType) {
        return null;
    }

    protected void addUrlsForPath(Set<String> urls, String path) {
        urls.add(path);
        if (this.useDefaultSuffixPattern && path.indexOf(46) == -1 && !path.endsWith("/")) {
            urls.add(String.valueOf(path) + ".*");
            urls.add(String.valueOf(path) + "/");
        }
    }

    @Override
    protected void validateHandler(Object handler, HttpServletRequest request) throws Exception {
        RequestMapping mapping = this.cachedMappings.get(handler.getClass());
        if (mapping == null) {
            mapping = (RequestMapping)AnnotationUtils.findAnnotation(handler.getClass(), RequestMapping.class);
        }
        if (mapping != null) {
            this.validateMapping(mapping, request);
        }
        request.setAttribute(USE_DEFAULT_SUFFIX_PATTERN, (Object)this.useDefaultSuffixPattern);
    }

    protected void validateMapping(RequestMapping mapping, HttpServletRequest request) throws Exception {
        RequestMethod[] mappedMethods = mapping.method();
        if (!ServletAnnotationMappingUtils.checkRequestMethod(mappedMethods, request)) {
            String[] supportedMethods = new String[mappedMethods.length];
            int i = 0;
            while (i < mappedMethods.length) {
                supportedMethods[i] = mappedMethods[i].name();
                ++i;
            }
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), supportedMethods);
        }
        String[] mappedParams = mapping.params();
        if (!ServletAnnotationMappingUtils.checkParameters(mappedParams, request)) {
            throw new UnsatisfiedServletRequestParameterException(mappedParams, request.getParameterMap());
        }
        Object[] mappedHeaders = mapping.headers();
        if (!ServletAnnotationMappingUtils.checkHeaders((String[])mappedHeaders, request)) {
            throw new ServletRequestBindingException("Header conditions \"" + StringUtils.arrayToDelimitedString((Object[])mappedHeaders, (String)", ") + "\" not met for actual request");
        }
    }

    @Override
    protected boolean supportsTypeLevelMappings() {
        return true;
    }
}

