/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceHttpMessageConverter<T extends Source>
extends AbstractXmlHttpMessageConverter<T> {
    @Override
    public boolean supports(Class<?> clazz) {
        return DOMSource.class.equals(clazz) || SAXSource.class.equals(clazz) || StreamSource.class.equals(clazz) || Source.class.equals(clazz);
    }

    @Override
    protected T readFromSource(Class clazz, HttpHeaders headers, Source source) throws IOException {
        try {
            if (DOMSource.class.equals((Object)clazz)) {
                DOMResult domResult = new DOMResult();
                this.transform(source, domResult);
                return (T)new DOMSource(domResult.getNode());
            }
            if (SAXSource.class.equals((Object)clazz)) {
                ByteArrayInputStream bis = this.transformToByteArrayInputStream(source);
                return (T)new SAXSource(new InputSource(bis));
            }
            if (StreamSource.class.equals((Object)clazz) || Source.class.equals((Object)clazz)) {
                ByteArrayInputStream bis = this.transformToByteArrayInputStream(source);
                return (T)new StreamSource(bis);
            }
            throw new HttpMessageConversionException("Could not read class [" + clazz + "]. Only DOMSource, SAXSource, and StreamSource are supported.");
        }
        catch (TransformerException ex) {
            throw new HttpMessageNotReadableException("Could not transform from [" + source + "] to [" + clazz + "]", ex);
        }
    }

    private ByteArrayInputStream transformToByteArrayInputStream(Source source) throws TransformerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transform(source, new StreamResult(bos));
        return new ByteArrayInputStream(bos.toByteArray());
    }

    @Override
    protected Long getContentLength(T t, MediaType contentType) {
        if (t instanceof DOMSource) {
            try {
                CountingOutputStream os = new CountingOutputStream();
                this.transform((Source)t, new StreamResult(os));
                return os.count;
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected void writeToResult(T t, HttpHeaders headers, Result result) throws IOException {
        try {
            this.transform((Source)t, result);
        }
        catch (TransformerException ex) {
            throw new HttpMessageNotWritableException("Could not transform [" + t + "] to [" + result + "]", ex);
        }
    }

    private static class CountingOutputStream
    extends OutputStream {
        private long count = 0L;

        private CountingOutputStream() {
        }

        public void write(int b) throws IOException {
            ++this.count;
        }

        public void write(byte[] b) throws IOException {
            this.count += (long)b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.count += (long)len;
        }
    }
}

