/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractClientHttpResponse;

final class HttpComponentsClientHttpResponse
extends AbstractClientHttpResponse {
    private final HttpResponse httpResponse;
    private HttpHeaders headers;

    HttpComponentsClientHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public int getRawStatusCode() throws IOException {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            Header[] headerArray = this.httpResponse.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                this.headers.add(header.getName(), header.getValue());
                ++n2;
            }
        }
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        return entity != null ? entity.getContent() : null;
    }

    public void close() {
        HttpEntity entity = this.httpResponse.getEntity();
        if (entity != null) {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException iOException) {}
        }
    }
}

