/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxws;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.jaxws.JaxWsSoapFaultException;
import org.springframework.remoting.jaxws.LocalJaxWsServiceFactory;

public class JaxWsPortClientInterceptor
extends LocalJaxWsServiceFactory
implements MethodInterceptor,
InitializingBean {
    private Service jaxWsService;
    private String portName;
    private Class<?> serviceInterface;
    private boolean lookupServiceOnStartup = true;
    private QName portQName;
    private Object portStub;
    private final Object preparationMonitor = new Object();

    public void setJaxWsService(Service jaxWsService) {
        this.jaxWsService = jaxWsService;
    }

    public Service getJaxWsService() {
        return this.jaxWsService;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setLookupServiceOnStartup(boolean lookupServiceOnStartup) {
        this.lookupServiceOnStartup = lookupServiceOnStartup;
    }

    public void afterPropertiesSet() {
        if (this.lookupServiceOnStartup) {
            this.prepare();
        }
    }

    public void prepare() {
        if (this.getServiceInterface() == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        Service serviceToUse = this.getJaxWsService();
        if (serviceToUse == null) {
            serviceToUse = this.createJaxWsService();
        }
        this.portQName = this.getQName(this.getPortName() != null ? this.getPortName() : this.getServiceInterface().getName());
        this.portStub = this.getPortName() != null ? serviceToUse.getPort(this.portQName, this.getServiceInterface()) : serviceToUse.getPort(this.getServiceInterface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPrepared() {
        Object object = this.preparationMonitor;
        synchronized (object) {
            return this.portStub != null;
        }
    }

    protected final QName getPortQName() {
        return this.portQName;
    }

    protected Object getPortStub() {
        return this.portStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (AopUtils.isToStringMethod((Method)invocation.getMethod())) {
            return "JAX-WS proxy for port [" + this.getPortName() + "] of service [" + this.getServiceName() + "]";
        }
        Object object = this.preparationMonitor;
        synchronized (object) {
            if (!this.isPrepared()) {
                this.prepare();
            }
        }
        return this.doInvoke(invocation);
    }

    protected Object doInvoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.doInvoke(invocation, this.getPortStub());
        }
        catch (SOAPFaultException ex) {
            throw new JaxWsSoapFaultException(ex);
        }
        catch (ProtocolException ex) {
            return new RemoteConnectFailureException("Could not connect to remote service [" + this.portQName + "]", (Throwable)ex);
        }
        catch (WebServiceException ex) {
            throw new RemoteAccessException("Could not access remote service at [" + this.portQName + "]", (Throwable)ex);
        }
    }

    protected Object doInvoke(MethodInvocation invocation, Object portStub) throws Throwable {
        Method method = invocation.getMethod();
        try {
            return method.invoke(portStub, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Invocation of stub method failed: " + method, ex);
        }
    }
}

