/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import org.springframework.web.context.request.RequestAttributes;

public abstract class RequestContextHolder {
    private static final ThreadLocal requestAttributesHolder = new ThreadLocal();
    private static final ThreadLocal inheritableRequestAttributesHolder = new InheritableThreadLocal();

    public static void resetRequestAttributes() {
        requestAttributesHolder.set(null);
        inheritableRequestAttributesHolder.set(null);
    }

    public static void setRequestAttributes(RequestAttributes attributes) {
        RequestContextHolder.setRequestAttributes(attributes, false);
    }

    public static void setRequestAttributes(RequestAttributes attributes, boolean inheritable) {
        if (inheritable) {
            inheritableRequestAttributesHolder.set(attributes);
            requestAttributesHolder.set(null);
        } else {
            requestAttributesHolder.set(attributes);
            inheritableRequestAttributesHolder.set(null);
        }
    }

    public static RequestAttributes getRequestAttributes() {
        RequestAttributes attributes = (RequestAttributes)requestAttributesHolder.get();
        if (attributes == null) {
            attributes = (RequestAttributes)inheritableRequestAttributesHolder.get();
        }
        return attributes;
    }

    public static RequestAttributes currentRequestAttributes() throws IllegalStateException {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            throw new IllegalStateException("No thread-bound request found: Are you referring to request attributes outside of an actual web request? If you are actually operating within a web request and still receive this message,your code is probably running outside of DispatcherServlet/DispatcherPortlet: In this case, use RequestContextListener or RequestContextFilter to expose the current request.");
        }
        return attributes;
    }
}

