/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.lang.Nullable;
import org.springframework.test.context.transaction.TransactionContext;

class TransactionContextHolder {
    private static final ThreadLocal<TransactionContext> currentTransactionContext = new NamedInheritableThreadLocal("Test Transaction Context");

    TransactionContextHolder() {
    }

    static void setCurrentTransactionContext(@Nullable TransactionContext transactionContext) {
        currentTransactionContext.set(transactionContext);
    }

    @Nullable
    static TransactionContext getCurrentTransactionContext() {
        return currentTransactionContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static TransactionContext removeCurrentTransactionContext() {
        ThreadLocal<TransactionContext> threadLocal = currentTransactionContext;
        synchronized (threadLocal) {
            TransactionContext transactionContext = currentTransactionContext.get();
            currentTransactionContext.remove();
            return transactionContext;
        }
    }
}

