/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;

public abstract class AbstractDelegatingSmartContextLoader
implements SmartContextLoader {
    private static final Log logger = LogFactory.getLog(AbstractDelegatingSmartContextLoader.class);

    protected abstract SmartContextLoader getXmlLoader();

    protected abstract SmartContextLoader getAnnotationConfigLoader();

    @Override
    public final String[] processLocations(Class<?> clazz, String ... locations) {
        throw new UnsupportedOperationException("DelegatingSmartContextLoaders do not support the ContextLoader SPI. Call processContextConfiguration(ContextConfigurationAttributes) instead.");
    }

    @Override
    public final ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("DelegatingSmartContextLoaders do not support the ContextLoader SPI. Call loadContext(MergedContextConfiguration) instead.");
    }

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        Assert.notNull((Object)configAttributes, (String)"configAttributes must not be null");
        Assert.isTrue((!configAttributes.hasLocations() || !configAttributes.hasClasses() ? 1 : 0) != 0, (String)String.format("Cannot process locations AND classes for context configuration %s: configure one or the other, but not both.", configAttributes));
        if (configAttributes.hasLocations()) {
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getXmlLoader(), configAttributes);
        } else if (configAttributes.hasClasses()) {
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getAnnotationConfigLoader(), configAttributes);
        } else {
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getXmlLoader(), configAttributes);
            boolean xmlLoaderDetectedDefaults = configAttributes.hasLocations();
            if (xmlLoaderDetectedDefaults && logger.isInfoEnabled()) {
                logger.info((Object)String.format("%s detected default locations for context configuration %s.", AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), configAttributes));
            }
            if (configAttributes.hasClasses()) {
                throw new IllegalStateException(String.format("%s should NOT have detected default configuration classes for context configuration %s.", AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), configAttributes));
            }
            AbstractDelegatingSmartContextLoader.delegateProcessing(this.getAnnotationConfigLoader(), configAttributes);
            if (configAttributes.hasClasses() && logger.isInfoEnabled()) {
                logger.info((Object)String.format("%s detected default configuration classes for context configuration %s.", AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), configAttributes));
            }
            if (!xmlLoaderDetectedDefaults && configAttributes.hasLocations()) {
                throw new IllegalStateException(String.format("%s should NOT have detected default locations for context configuration %s.", AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), configAttributes));
            }
            if (configAttributes.hasLocations() && configAttributes.hasClasses()) {
                String msg = String.format("Configuration error: both default locations AND default configuration classes were detected for context configuration %s; configure one or the other, but not both.", configAttributes);
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        SmartContextLoader[] candidates;
        Assert.notNull((Object)mergedConfig, (String)"MergedContextConfiguration must not be null");
        if (mergedConfig.hasLocations() && mergedConfig.hasClasses()) {
            throw new IllegalStateException(String.format("Neither %s nor %s supports loading an ApplicationContext from %s: declare either 'locations' or 'classes' but not both.", AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), mergedConfig));
        }
        for (SmartContextLoader loader : candidates = new SmartContextLoader[]{this.getXmlLoader(), this.getAnnotationConfigLoader()}) {
            if (!this.supports(loader, mergedConfig)) continue;
            return AbstractDelegatingSmartContextLoader.delegateLoading(loader, mergedConfig);
        }
        if (!mergedConfig.getContextInitializerClasses().isEmpty() || !mergedConfig.getContextCustomizers().isEmpty()) {
            return AbstractDelegatingSmartContextLoader.delegateLoading(this.getAnnotationConfigLoader(), mergedConfig);
        }
        throw new IllegalStateException(String.format("Neither %s nor %s was able to load an ApplicationContext from %s.", AbstractDelegatingSmartContextLoader.name(this.getXmlLoader()), AbstractDelegatingSmartContextLoader.name(this.getAnnotationConfigLoader()), mergedConfig));
    }

    private static void delegateProcessing(SmartContextLoader loader, ContextConfigurationAttributes configAttributes) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Delegating to %s to process context configuration %s.", AbstractDelegatingSmartContextLoader.name(loader), configAttributes));
        }
        loader.processContextConfiguration(configAttributes);
    }

    private static ApplicationContext delegateLoading(SmartContextLoader loader, MergedContextConfiguration mergedConfig) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Delegating to %s to load context from %s.", AbstractDelegatingSmartContextLoader.name(loader), mergedConfig));
        }
        return loader.loadContext(mergedConfig);
    }

    private boolean supports(SmartContextLoader loader, MergedContextConfiguration mergedConfig) {
        if (loader == this.getAnnotationConfigLoader()) {
            return mergedConfig.hasClasses() && !mergedConfig.hasLocations();
        }
        return mergedConfig.hasLocations() && !mergedConfig.hasClasses();
    }

    private static String name(SmartContextLoader loader) {
        return loader.getClass().getSimpleName();
    }
}

