/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.support.MethodArgumentTypeMismatchException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;

public class MessageMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return Message.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Class paramType = parameter.getParameterType();
        if (!paramType.isAssignableFrom(message.getClass())) {
            throw new MethodArgumentTypeMismatchException(message, parameter, "The actual message type [" + ClassUtils.getQualifiedName(message.getClass()) + "] " + "does not match the expected type [" + ClassUtils.getQualifiedName((Class)paramType) + "]");
        }
        Class<?> expectedPayloadType = this.getPayloadType(parameter);
        Object payload = message.getPayload();
        if (payload != null && expectedPayloadType != null && !expectedPayloadType.isInstance(payload)) {
            throw new MethodArgumentTypeMismatchException(message, parameter, "The expected Message<?> payload type [" + ClassUtils.getQualifiedName(expectedPayloadType) + "] does not match the actual payload type [" + ClassUtils.getQualifiedName(payload.getClass()) + "]");
        }
        return message;
    }

    private Class<?> getPayloadType(MethodParameter parameter) {
        Type genericParamType = parameter.getGenericParameterType();
        ResolvableType resolvableType = ResolvableType.forType((Type)genericParamType).as(Message.class);
        return resolvableType.getGeneric(new int[]{0}).resolve(Object.class);
    }
}

