/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import org.springframework.messaging.Message;
import org.springframework.messaging.tcp.TcpConnection;
import org.springframework.messaging.tcp.reactor.PassThroughPromiseToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import reactor.core.composable.Promise;

public class ReactorTcpConnection<P>
implements TcpConnection<P> {
    private final reactor.tcp.TcpConnection<Message<P>, Message<P>> reactorTcpConnection;

    public ReactorTcpConnection(reactor.tcp.TcpConnection<Message<P>, Message<P>> connection) {
        this.reactorTcpConnection = connection;
    }

    @Override
    public ListenableFuture<Void> send(Message<P> message) {
        Promise promise = this.reactorTcpConnection.send(message);
        return new PassThroughPromiseToListenableFutureAdapter<Void>((Promise<Void>)promise);
    }

    @Override
    public void onReadInactivity(Runnable runnable, long inactivityDuration) {
        this.reactorTcpConnection.on().readIdle(inactivityDuration, runnable);
    }

    @Override
    public void onWriteInactivity(Runnable runnable, long inactivityDuration) {
        this.reactorTcpConnection.on().writeIdle(inactivityDuration, runnable);
    }

    @Override
    public void close() {
        this.reactorTcpConnection.close();
    }
}

