/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.transaction.TransactionSystemException;

public class WebLogicServerTransactionManagerFactoryBean
implements FactoryBean {
    private static final String TX_HELPER_CLASS_NAME = "weblogic.transaction.TxHelper";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TransactionManager transactionManager;

    public WebLogicServerTransactionManagerFactoryBean() throws TransactionSystemException {
        try {
            Class<?> helperClass = Class.forName(TX_HELPER_CLASS_NAME);
            this.logger.debug((Object)"Found WebLogic's TxHelper: weblogic.transaction.TxHelper");
            Method method = helperClass.getMethod("getTransactionManager", null);
            this.transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException ex) {
            throw new TransactionSystemException("Could not find WebLogic's TxHelper class", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionSystemException("WebLogic's TxHelper.getTransactionManager method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not access WebLogic's TxHelper.getTransactionManager method", ex);
        }
    }

    public Object getObject() {
        return this.transactionManager;
    }

    public Class getObjectType() {
        return this.transactionManager.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

