/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentScanBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String BASE_PACKAGE_ATTRIBUTE = "base-package";
    private static final String RESOURCE_PATTERN_ATTRIBUTE = "resource-pattern";
    private static final String USE_DEFAULT_FILTERS_ATTRIBUTE = "use-default-filters";
    private static final String ANNOTATION_CONFIG_ATTRIBUTE = "annotation-config";
    private static final String NAME_GENERATOR_ATTRIBUTE = "name-generator";
    private static final String SCOPE_RESOLVER_ATTRIBUTE = "scope-resolver";
    private static final String SCOPED_PROXY_ATTRIBUTE = "scoped-proxy";
    private static final String EXCLUDE_FILTER_ELEMENT = "exclude-filter";
    private static final String INCLUDE_FILTER_ELEMENT = "include-filter";
    private static final String FILTER_TYPE_ATTRIBUTE = "type";
    private static final String FILTER_EXPRESSION_ATTRIBUTE = "expression";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        ResourceLoader resourceLoader = parserContext.getReaderContext().getResourceLoader();
        Object source = parserContext.extractSource((Object)element);
        boolean useDefaultFilters = true;
        if (element.hasAttribute(USE_DEFAULT_FILTERS_ATTRIBUTE)) {
            useDefaultFilters = Boolean.valueOf(element.getAttribute(USE_DEFAULT_FILTERS_ATTRIBUTE));
        }
        boolean annotationConfig = true;
        if (element.hasAttribute(ANNOTATION_CONFIG_ATTRIBUTE)) {
            annotationConfig = Boolean.valueOf(element.getAttribute(ANNOTATION_CONFIG_ATTRIBUTE));
        }
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(parserContext.getRegistry(), useDefaultFilters);
        scanner.setResourceLoader(resourceLoader);
        scanner.setBeanDefinitionDefaults(parserContext.getDelegate().getBeanDefinitionDefaults());
        scanner.setAutowireCandidatePatterns(parserContext.getDelegate().getAutowireCandidatePatterns());
        String basePackage = element.getAttribute(BASE_PACKAGE_ATTRIBUTE);
        String[] basePackages = StringUtils.commaDelimitedListToStringArray((String)basePackage);
        if (element.hasAttribute(RESOURCE_PATTERN_ATTRIBUTE)) {
            scanner.setResourcePattern(element.getAttribute(RESOURCE_PATTERN_ATTRIBUTE));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            TypeFilter typeFilter;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String localName = node.getLocalName();
            if (INCLUDE_FILTER_ELEMENT.equals(localName)) {
                typeFilter = this.createTypeFilter((Element)node, resourceLoader.getClassLoader());
                scanner.addIncludeFilter(typeFilter);
                continue;
            }
            if (!EXCLUDE_FILTER_ELEMENT.equals(localName)) continue;
            typeFilter = this.createTypeFilter((Element)node, resourceLoader.getClassLoader());
            scanner.addExcludeFilter(typeFilter);
        }
        if (element.hasAttribute(NAME_GENERATOR_ATTRIBUTE)) {
            BeanNameGenerator beanNameGenerator = (BeanNameGenerator)this.instantiateUserDefinedStrategy(element.getAttribute(NAME_GENERATOR_ATTRIBUTE), BeanNameGenerator.class, resourceLoader.getClassLoader());
            scanner.setBeanNameGenerator(beanNameGenerator);
        }
        if (element.hasAttribute(SCOPE_RESOLVER_ATTRIBUTE)) {
            if (element.hasAttribute(SCOPED_PROXY_ATTRIBUTE)) {
                parserContext.getReaderContext().error("Cannot define both 'scope-resolver' and 'scoped-proxy' on <component-scan> tag.", (Object)element);
            }
            ScopeMetadataResolver scopeMetadataResolver = (ScopeMetadataResolver)this.instantiateUserDefinedStrategy(element.getAttribute(SCOPE_RESOLVER_ATTRIBUTE), ScopeMetadataResolver.class, resourceLoader.getClassLoader());
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        if (element.hasAttribute(SCOPED_PROXY_ATTRIBUTE)) {
            String mode = element.getAttribute(SCOPED_PROXY_ATTRIBUTE);
            if ("targetClass".equals(mode)) {
                scanner.setScopedProxyMode(ScopedProxyMode.TARGET_CLASS);
            } else if ("interfaces".equals(mode)) {
                scanner.setScopedProxyMode(ScopedProxyMode.INTERFACES);
            } else if ("no".equals(mode)) {
                scanner.setScopedProxyMode(ScopedProxyMode.NO);
            } else {
                throw new IllegalArgumentException("scoped-proxy only supports 'no', 'interfaces' and 'targetClass'");
            }
        }
        Set<BeanDefinitionHolder> beanDefinitions = scanner.doScan(basePackages);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), source);
        for (BeanDefinitionHolder beanDefHolder : beanDefinitions) {
            AbstractBeanDefinition beanDef = (AbstractBeanDefinition)beanDefHolder.getBeanDefinition();
            beanDef.setSource(parserContext.extractSource(beanDef.getSource()));
            compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(beanDefHolder));
        }
        parserContext.getReaderContext().fireComponentRegistered((ComponentDefinition)compositeDef);
        if (annotationConfig) {
            Set<BeanDefinitionHolder> processorDefinitions = AnnotationConfigUtils.registerAnnotationConfigProcessors(parserContext.getRegistry(), source);
            for (BeanDefinitionHolder processorDefinition : processorDefinitions) {
                parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition(processorDefinition));
            }
        }
        return null;
    }

    private Object instantiateUserDefinedStrategy(String className, Class strategyType, ClassLoader classLoader) {
        Object result = null;
        try {
            result = classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new BeanCreationException("Class [" + className + "] for strategy [" + strategyType.getName() + "] not found", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new BeanCreationException("Unable to instantiate class [" + className + "] for strategy [" + strategyType.getName() + "]. A zero-argument constructor is required", (Throwable)ex);
        }
        if (!strategyType.isAssignableFrom(result.getClass())) {
            throw new BeanCreationException("Provided class name must be an implementation of " + strategyType);
        }
        return result;
    }

    private TypeFilter createTypeFilter(Element element, ClassLoader classLoader) {
        String filterType = element.getAttribute(FILTER_TYPE_ATTRIBUTE);
        String expression = element.getAttribute(FILTER_EXPRESSION_ATTRIBUTE);
        try {
            if ("annotation".equals(filterType)) {
                return new AnnotationTypeFilter(classLoader.loadClass(expression));
            }
            if ("assignable".equals(filterType)) {
                return new AssignableTypeFilter(classLoader.loadClass(expression));
            }
            if ("regex".equals(filterType)) {
                return new RegexPatternTypeFilter(Pattern.compile(expression));
            }
            if ("aspectj".equals(filterType)) {
                return new AspectJTypeFilter(expression, classLoader);
            }
            throw new IllegalArgumentException("Unsupported filter type: " + filterType);
        }
        catch (ClassNotFoundException ex) {
            throw new FatalBeanException("Type filter class not found: " + expression, (Throwable)ex);
        }
    }
}

