/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FormLoginBeanDefinitionParser {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_LOGIN_URL = "login-processing-url";
    static final String ATT_LOGIN_PAGE = "login-page";
    private static final String DEF_LOGIN_PAGE = "/spring_security_login";
    private static final String ATT_FORM_LOGIN_TARGET_URL = "default-target-url";
    private static final String ATT_ALWAYS_USE_DEFAULT_TARGET_URL = "always-use-default-target";
    private static final String DEF_FORM_LOGIN_TARGET_URL = "/";
    private static final String ATT_USERNAME_PARAMETER = "username-parameter";
    private static final String ATT_PASSWORD_PARAMETER = "password-parameter";
    private static final String ATT_FORM_LOGIN_AUTHENTICATION_FAILURE_URL = "authentication-failure-url";
    private static final String DEF_FORM_LOGIN_AUTHENTICATION_FAILURE_URL = "/spring_security_login?login_error";
    private static final String ATT_SUCCESS_HANDLER_REF = "authentication-success-handler-ref";
    private static final String ATT_FAILURE_HANDLER_REF = "authentication-failure-handler-ref";
    private final String defaultLoginProcessingUrl;
    private final String filterClassName;
    private final BeanReference requestCache;
    private final BeanReference sessionStrategy;
    private final boolean allowSessionCreation;
    private final BeanReference portMapper;
    private final BeanReference portResolver;
    private RootBeanDefinition filterBean;
    private RootBeanDefinition entryPointBean;
    private String loginPage;

    FormLoginBeanDefinitionParser(String defaultLoginProcessingUrl, String filterClassName, BeanReference requestCache, BeanReference sessionStrategy, boolean allowSessionCreation, BeanReference portMapper, BeanReference portResolver) {
        this.defaultLoginProcessingUrl = defaultLoginProcessingUrl;
        this.filterClassName = filterClassName;
        this.requestCache = requestCache;
        this.sessionStrategy = sessionStrategy;
        this.allowSessionCreation = allowSessionCreation;
        this.portMapper = portMapper;
        this.portResolver = portResolver;
    }

    public BeanDefinition parse(Element elt, ParserContext pc) {
        String loginUrl = null;
        String defaultTargetUrl = null;
        String authenticationFailureUrl = null;
        String alwaysUseDefault = null;
        String successHandlerRef = null;
        String failureHandlerRef = null;
        String usernameParameter = null;
        String passwordParameter = null;
        String authDetailsSourceRef = null;
        Object source = null;
        if (elt != null) {
            source = pc.extractSource((Object)elt);
            loginUrl = elt.getAttribute(ATT_LOGIN_URL);
            WebConfigUtils.validateHttpRedirect(loginUrl, pc, source);
            defaultTargetUrl = elt.getAttribute(ATT_FORM_LOGIN_TARGET_URL);
            WebConfigUtils.validateHttpRedirect(defaultTargetUrl, pc, source);
            authenticationFailureUrl = elt.getAttribute(ATT_FORM_LOGIN_AUTHENTICATION_FAILURE_URL);
            WebConfigUtils.validateHttpRedirect(authenticationFailureUrl, pc, source);
            alwaysUseDefault = elt.getAttribute(ATT_ALWAYS_USE_DEFAULT_TARGET_URL);
            this.loginPage = elt.getAttribute(ATT_LOGIN_PAGE);
            successHandlerRef = elt.getAttribute(ATT_SUCCESS_HANDLER_REF);
            failureHandlerRef = elt.getAttribute(ATT_FAILURE_HANDLER_REF);
            authDetailsSourceRef = elt.getAttribute("authentication-details-source-ref");
            if (!StringUtils.hasText((String)this.loginPage)) {
                this.loginPage = null;
            }
            WebConfigUtils.validateHttpRedirect(this.loginPage, pc, source);
            usernameParameter = elt.getAttribute(ATT_USERNAME_PARAMETER);
            passwordParameter = elt.getAttribute(ATT_PASSWORD_PARAMETER);
        }
        this.filterBean = this.createFilterBean(loginUrl, defaultTargetUrl, alwaysUseDefault, this.loginPage, authenticationFailureUrl, successHandlerRef, failureHandlerRef, authDetailsSourceRef);
        if (StringUtils.hasText(usernameParameter)) {
            this.filterBean.getPropertyValues().addPropertyValue("usernameParameter", usernameParameter);
        }
        if (StringUtils.hasText(passwordParameter)) {
            this.filterBean.getPropertyValues().addPropertyValue("passwordParameter", passwordParameter);
        }
        this.filterBean.setSource(source);
        BeanDefinitionBuilder entryPointBuilder = BeanDefinitionBuilder.rootBeanDefinition(LoginUrlAuthenticationEntryPoint.class);
        entryPointBuilder.getRawBeanDefinition().setSource(source);
        entryPointBuilder.addPropertyValue("loginFormUrl", (Object)(this.loginPage != null ? this.loginPage : DEF_LOGIN_PAGE));
        entryPointBuilder.addPropertyValue("portMapper", (Object)this.portMapper);
        entryPointBuilder.addPropertyValue("portResolver", (Object)this.portResolver);
        this.entryPointBean = (RootBeanDefinition)entryPointBuilder.getBeanDefinition();
        return null;
    }

    private RootBeanDefinition createFilterBean(String loginUrl, String defaultTargetUrl, String alwaysUseDefault, String loginPage, String authenticationFailureUrl, String successHandlerRef, String failureHandlerRef, String authDetailsSourceRef) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)this.filterClassName);
        if (!StringUtils.hasText((String)loginUrl)) {
            loginUrl = this.defaultLoginProcessingUrl;
        }
        filterBuilder.addPropertyValue("filterProcessesUrl", (Object)loginUrl);
        if (StringUtils.hasText((String)successHandlerRef)) {
            filterBuilder.addPropertyReference("authenticationSuccessHandler", successHandlerRef);
        } else {
            BeanDefinitionBuilder successHandler = BeanDefinitionBuilder.rootBeanDefinition(SavedRequestAwareAuthenticationSuccessHandler.class);
            if ("true".equals(alwaysUseDefault)) {
                successHandler.addPropertyValue("alwaysUseDefaultTargetUrl", (Object)Boolean.TRUE);
            }
            successHandler.addPropertyValue("requestCache", (Object)this.requestCache);
            successHandler.addPropertyValue("defaultTargetUrl", (Object)(StringUtils.hasText((String)defaultTargetUrl) ? defaultTargetUrl : DEF_FORM_LOGIN_TARGET_URL));
            filterBuilder.addPropertyValue("authenticationSuccessHandler", (Object)successHandler.getBeanDefinition());
        }
        if (StringUtils.hasText((String)authDetailsSourceRef)) {
            filterBuilder.addPropertyReference("authenticationDetailsSource", authDetailsSourceRef);
        }
        if (this.sessionStrategy != null) {
            filterBuilder.addPropertyValue("sessionAuthenticationStrategy", (Object)this.sessionStrategy);
        }
        if (StringUtils.hasText((String)failureHandlerRef)) {
            filterBuilder.addPropertyReference("authenticationFailureHandler", failureHandlerRef);
        } else {
            BeanDefinitionBuilder failureHandler = BeanDefinitionBuilder.rootBeanDefinition(SimpleUrlAuthenticationFailureHandler.class);
            if (!StringUtils.hasText((String)authenticationFailureUrl)) {
                authenticationFailureUrl = StringUtils.hasText((String)loginPage) ? loginPage : DEF_FORM_LOGIN_AUTHENTICATION_FAILURE_URL;
            }
            failureHandler.addPropertyValue("defaultFailureUrl", (Object)authenticationFailureUrl);
            failureHandler.addPropertyValue("allowSessionCreation", (Object)this.allowSessionCreation);
            filterBuilder.addPropertyValue("authenticationFailureHandler", (Object)failureHandler.getBeanDefinition());
        }
        return (RootBeanDefinition)filterBuilder.getBeanDefinition();
    }

    RootBeanDefinition getFilterBean() {
        return this.filterBean;
    }

    RootBeanDefinition getEntryPointBean() {
        return this.entryPointBean;
    }

    String getLoginPage() {
        return this.loginPage;
    }
}

