/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.approval;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.util.Assert;

public class JdbcApprovalStore
implements ApprovalStore {
    private final JdbcTemplate jdbcTemplate;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RowMapper<Approval> rowMapper = new AuthorizationRowMapper();
    private static final String TABLE_NAME = "oauth_approvals";
    private static final String FIELDS = "expiresAt,status,lastModifiedAt,userId,clientId,scope";
    private static final String WHERE_KEY = "where userId=? and clientId=?";
    private static final String WHERE_KEY_AND_SCOPE = "where userId=? and clientId=? and scope=?";
    private static final String DEFAULT_ADD_APPROVAL_STATEMENT = String.format("insert into %s ( %s ) values (?,?,?,?,?,?)", "oauth_approvals", "expiresAt,status,lastModifiedAt,userId,clientId,scope");
    private static final String DEFAULT_REFRESH_APPROVAL_STATEMENT = String.format("update %s set expiresAt=?, status=?, lastModifiedAt=? where userId=? and clientId=? and scope=?", "oauth_approvals");
    private static final String DEFAULT_GET_APPROVAL_SQL = String.format("select %s from %s where userId=? and clientId=?", "expiresAt,status,lastModifiedAt,userId,clientId,scope", "oauth_approvals");
    private static final String DEFAULT_DELETE_APPROVAL_SQL = String.format("delete from %s where userId=? and clientId=? and scope=?", "oauth_approvals");
    private static final String DEFAULT_EXPIRE_APPROVAL_STATEMENT = String.format("update %s set expiresAt = ? where userId=? and clientId=? and scope=?", "oauth_approvals");
    private String addApprovalStatement = DEFAULT_ADD_APPROVAL_STATEMENT;
    private String refreshApprovalStatement = DEFAULT_REFRESH_APPROVAL_STATEMENT;
    private String findApprovalStatement = DEFAULT_GET_APPROVAL_SQL;
    private String deleteApprovalStatment = DEFAULT_DELETE_APPROVAL_SQL;
    private String expireApprovalStatement = DEFAULT_EXPIRE_APPROVAL_STATEMENT;
    private boolean handleRevocationsAsExpiry = false;

    public JdbcApprovalStore(DataSource dataSource) {
        Assert.notNull((Object)dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setHandleRevocationsAsExpiry(boolean handleRevocationsAsExpiry) {
        this.handleRevocationsAsExpiry = handleRevocationsAsExpiry;
    }

    public void setAddApprovalStatement(String addApprovalStatement) {
        this.addApprovalStatement = addApprovalStatement;
    }

    public void setFindApprovalStatement(String findApprovalStatement) {
        this.findApprovalStatement = findApprovalStatement;
    }

    public void setDeleteApprovalStatment(String deleteApprovalStatment) {
        this.deleteApprovalStatment = deleteApprovalStatment;
    }

    public void setExpireApprovalStatement(String expireApprovalStatement) {
        this.expireApprovalStatement = expireApprovalStatement;
    }

    @Override
    public boolean addApprovals(Collection<Approval> approvals) {
        this.logger.debug((Object)String.format("adding approvals: [%s]", approvals));
        boolean success = true;
        for (Approval approval : approvals) {
            if (this.updateApproval(this.refreshApprovalStatement, approval) || this.updateApproval(this.addApprovalStatement, approval)) continue;
            success = false;
        }
        return success;
    }

    @Override
    public boolean revokeApprovals(Collection<Approval> approvals) {
        this.logger.debug((Object)String.format("Revoking approvals: [%s]", approvals));
        boolean success = true;
        for (final Approval approval : approvals) {
            int refreshed;
            if (this.handleRevocationsAsExpiry) {
                refreshed = this.jdbcTemplate.update(this.expireApprovalStatement, new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                        ps.setString(2, approval.getUserId());
                        ps.setString(3, approval.getClientId());
                        ps.setString(4, approval.getScope());
                    }
                });
                if (refreshed == 1) continue;
                success = false;
                continue;
            }
            refreshed = this.jdbcTemplate.update(this.deleteApprovalStatment, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, approval.getUserId());
                    ps.setString(2, approval.getClientId());
                    ps.setString(3, approval.getScope());
                }
            });
            if (refreshed == 1) continue;
            success = false;
        }
        return success;
    }

    public boolean purgeExpiredApprovals() {
        this.logger.debug((Object)"Purging expired approvals from database");
        try {
            int deleted = this.jdbcTemplate.update(this.deleteApprovalStatment + " where expiresAt <= ?", new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setTimestamp(1, new Timestamp(new Date().getTime()));
                }
            });
            this.logger.debug((Object)(deleted + " expired approvals deleted"));
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)"Error purging expired approvals", (Throwable)ex);
            return false;
        }
        return true;
    }

    public List<Approval> getApprovals(String userName, String clientId) {
        return this.jdbcTemplate.query(this.findApprovalStatement, this.rowMapper, new Object[]{userName, clientId});
    }

    private boolean updateApproval(String sql, final Approval approval) {
        this.logger.debug((Object)String.format("refreshing approval: [%s]", approval));
        int refreshed = this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setTimestamp(1, new Timestamp(approval.getExpiresAt().getTime()));
                ps.setString(2, (approval.getStatus() == null ? Approval.ApprovalStatus.APPROVED : approval.getStatus()).toString());
                ps.setTimestamp(3, new Timestamp(approval.getLastUpdatedAt().getTime()));
                ps.setString(4, approval.getUserId());
                ps.setString(5, approval.getClientId());
                ps.setString(6, approval.getScope());
            }
        });
        return refreshed == 1;
    }

    private static class AuthorizationRowMapper
    implements RowMapper<Approval> {
        private AuthorizationRowMapper() {
        }

        public Approval mapRow(ResultSet rs, int rowNum) throws SQLException {
            String userName = rs.getString(4);
            String clientId = rs.getString(5);
            String scope = rs.getString(6);
            Timestamp expiresAt = rs.getTimestamp(1);
            String status = rs.getString(2);
            Timestamp lastUpdatedAt = rs.getTimestamp(3);
            return new Approval(userName, clientId, scope, expiresAt, Approval.ApprovalStatus.valueOf(status), lastUpdatedAt);
        }
    }
}

