/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.approval;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.util.Assert;

public class TokenServicesUserApprovalHandler
implements UserApprovalHandler,
InitializingBean {
    private static Log logger = LogFactory.getLog(TokenServicesUserApprovalHandler.class);
    private String approvalParameter = "user_oauth_approval";
    private AuthorizationServerTokenServices tokenServices;

    public void setApprovalParameter(String approvalParameter) {
        this.approvalParameter = approvalParameter;
    }

    public void setTokenServices(AuthorizationServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void afterPropertiesSet() {
        Assert.state((this.tokenServices != null ? 1 : 0) != 0, (String)"AuthorizationServerTokenServices must be provided");
    }

    public AuthorizationRequest updateBeforeApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest;
    }

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        String flag = authorizationRequest.getApprovalParameters().get(this.approvalParameter);
        boolean approved = flag != null && flag.toLowerCase().equals("true");
        OAuth2Authentication authentication = new OAuth2Authentication(authorizationRequest, userAuthentication);
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Looking up existing token for ");
            builder.append("client_id=" + authorizationRequest.getClientId());
            builder.append(", scope=" + authorizationRequest.getScope());
            builder.append(" and username=" + userAuthentication.getName());
            logger.debug((Object)builder.toString());
        }
        OAuth2AccessToken accessToken = this.tokenServices.getAccessToken(authentication);
        logger.debug((Object)("Existing access token=" + accessToken));
        if (accessToken != null && !accessToken.isExpired()) {
            logger.debug((Object)("User already approved with token=" + accessToken));
            approved = true;
        } else {
            logger.debug((Object)"Checking explicit approval");
            approved = userAuthentication.isAuthenticated() && approved;
        }
        return approved;
    }
}

