/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.AuthorizationRequestManager;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationRequestManager
implements AuthorizationRequestManager {
    private final ClientDetailsService clientDetailsService;
    private boolean revealValidScopes = false;

    public void setRevealValidScopes(boolean revealValidScopes) {
        this.revealValidScopes = revealValidScopes;
    }

    public DefaultAuthorizationRequestManager(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    @Override
    public AuthorizationRequest createAuthorizationRequest(Map<String, String> parameters) {
        String clientId = parameters.get("client_id");
        if (clientId == null) {
            throw new InvalidClientException("A client id must be provided");
        }
        ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        Set<String> scopes = OAuth2Utils.parseParameterList(parameters.get("scope"));
        if (scopes == null || scopes.isEmpty()) {
            scopes = clientDetails.getScope();
        }
        DefaultAuthorizationRequest request = new DefaultAuthorizationRequest(parameters, Collections.<String, String>emptyMap(), clientId, scopes);
        request.addClientDetails(clientDetails);
        return request;
    }

    @Override
    public void validateParameters(Map<String, String> parameters, ClientDetails clientDetails) {
        if (parameters.containsKey("scope") && clientDetails.isScoped()) {
            Set<String> validScope = clientDetails.getScope();
            for (String scope : OAuth2Utils.parseParameterList(parameters.get("scope"))) {
                if (validScope.contains(scope)) continue;
                InvalidScopeException exception = this.revealValidScopes ? new InvalidScopeException("Invalid scope: " + scope, validScope) : new InvalidScopeException("Invalid scope: " + scope);
                throw exception;
            }
        }
    }
}

