/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.springframework.util.Assert;

public interface MailReceiver {
    public Message[] receive() throws MessagingException;

    public static class MailReceiverContext {
        private final Folder folder;
        private volatile Message[] messages = new Message[0];

        MailReceiverContext(Folder folder) {
            this.folder = folder;
        }

        Message[] getMessages() {
            return this.messages;
        }

        void setMessages(Message[] messages) {
            Assert.noNullElements((Object[])messages, (String)"messages cannot be null");
            this.messages = messages;
        }

        Folder getFolder() {
            return this.folder;
        }
    }
}

