/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.util.Collection;
import java.util.Collections;
import org.springframework.aop.support.AopUtils;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.util.Assert;

public class EmbeddedWrappers {
    private final boolean preferCollections;

    public EmbeddedWrappers(boolean preferCollections) {
        this.preferCollections = preferCollections;
    }

    public EmbeddedWrapper wrap(Object source) {
        return this.wrap(source, "___norel___");
    }

    public EmbeddedWrapper emptyCollectionOf(Class<?> type) {
        return new EmptyCollectionEmbeddedWrapper(type);
    }

    public EmbeddedWrapper wrap(Object source, String rel) {
        if (source == null) {
            return null;
        }
        if (source instanceof EmbeddedWrapper) {
            return (EmbeddedWrapper)source;
        }
        if (source instanceof Collection) {
            return new EmbeddedCollection((Collection)source, rel);
        }
        if (this.preferCollections) {
            return new EmbeddedCollection(Collections.singleton(source), rel);
        }
        return new EmbeddedElement(source, rel);
    }

    private static class EmptyCollectionEmbeddedWrapper
    implements EmbeddedWrapper {
        private final Class<?> type;

        public EmptyCollectionEmbeddedWrapper(Class<?> type) {
            Assert.notNull(type, (String)"Element type must not be null!");
            this.type = type;
        }

        @Override
        public String getRel() {
            return null;
        }

        @Override
        public Object getValue() {
            return Collections.emptySet();
        }

        @Override
        public Class<?> getRelTargetType() {
            return this.type;
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }

        @Override
        public boolean hasRel(String rel) {
            return false;
        }
    }

    private static class EmbeddedCollection
    extends AbstractEmbeddedWrapper {
        private final Collection<Object> value;

        public EmbeddedCollection(Collection<Object> value, String rel) {
            super(rel);
            Assert.notNull(value, (String)"Collection must not be null!");
            if ("___norel___".equals(rel) && value.isEmpty()) {
                throw new IllegalArgumentException("Cannot wrap an empty collection with no rel given!");
            }
            this.value = value;
        }

        @Override
        public Collection<Object> getValue() {
            return this.value;
        }

        @Override
        protected Object peek() {
            return this.value.isEmpty() ? null : this.value.iterator().next();
        }

        @Override
        public boolean isCollectionValue() {
            return true;
        }
    }

    private static class EmbeddedElement
    extends AbstractEmbeddedWrapper {
        private final Object value;

        public EmbeddedElement(Object value, String rel) {
            super(rel);
            Assert.notNull((Object)value, (String)"Value must not be null!");
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        protected Object peek() {
            return this.getValue();
        }

        @Override
        public boolean isCollectionValue() {
            return false;
        }
    }

    private static abstract class AbstractEmbeddedWrapper
    implements EmbeddedWrapper {
        private static final String NO_REL = "___norel___";
        private final String rel;

        public AbstractEmbeddedWrapper(String rel) {
            Assert.hasText((String)rel, (String)"Rel must not be null or empty!");
            this.rel = rel;
        }

        @Override
        public String getRel() {
            return NO_REL.equals(this.rel) ? null : this.rel;
        }

        @Override
        public boolean hasRel(String rel) {
            return this.rel.equals(rel);
        }

        @Override
        public Class<?> getRelTargetType() {
            Object peek = this.peek();
            if (peek == null) {
                return null;
            }
            peek = peek instanceof Resource ? ((Resource)peek).getContent() : peek;
            return AopUtils.getTargetClass((Object)peek);
        }

        protected abstract Object peek();
    }
}

