/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.xml.sax.SAXException;

public class EmbeddedSolrServerFactory
implements SolrClientFactory,
DisposableBean {
    private static final String SOLR_HOME_SYSTEM_PROPERTY = "solr.solr.home";
    @Nullable
    private String solrHome;
    private AtomicReference<CoreContainer> coreContainer = new AtomicReference<Object>(null);
    private ConcurrentHashMap<String, EmbeddedSolrServer> servers = new ConcurrentHashMap();

    protected EmbeddedSolrServerFactory() {
    }

    public EmbeddedSolrServerFactory(String solrHome) throws ParserConfigurationException, IOException, SAXException {
        Assert.hasText((String)solrHome, (String)"SolrHome must not be null nor empty!");
        this.solrHome = solrHome;
    }

    public EmbeddedSolrServer getSolrClient() {
        return new EmbeddedSolrServer(this.getCoreContainer(), "collection1");
    }

    protected void initCoreContainer() {
        try {
            this.coreContainer.compareAndSet(null, this.createCoreContainer(this.solrHome));
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public final EmbeddedSolrServer createPathConfiguredSolrServer(String path) throws ParserConfigurationException, IOException, SAXException {
        return new EmbeddedSolrServer(this.createCoreContainer(path), "collection1");
    }

    private CoreContainer createCoreContainer(String path) throws FileNotFoundException, UnsupportedEncodingException {
        String solrHomeDirectory = System.getProperty(SOLR_HOME_SYSTEM_PROPERTY);
        if (StringUtils.isBlank((CharSequence)solrHomeDirectory)) {
            solrHomeDirectory = ResourceUtils.getFile((String)path).getPath();
        }
        solrHomeDirectory = URLDecoder.decode(solrHomeDirectory, "utf-8");
        File solrXmlFile = new File(solrHomeDirectory + "/solr.xml");
        if (ClassUtils.hasConstructor(CoreContainer.class, (Class[])new Class[]{String.class, File.class})) {
            return this.createCoreContainerViaConstructor(solrHomeDirectory, solrXmlFile);
        }
        return this.createCoreContainer(solrHomeDirectory, solrXmlFile);
    }

    private CoreContainer createCoreContainerViaConstructor(String solrHomeDirectory, File solrXmlFile) {
        Constructor constructor = ClassUtils.getConstructorIfAvailable(CoreContainer.class, (Class[])new Class[]{String.class, File.class});
        return (CoreContainer)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{solrHomeDirectory, solrXmlFile});
    }

    private CoreContainer createCoreContainer(String solrHomeDirectory, File solrXmlFile) {
        Method createAndLoadMethod = ClassUtils.getStaticMethod(CoreContainer.class, (String)"createAndLoad", (Class[])new Class[]{String.class, File.class});
        if (createAndLoadMethod != null) {
            return (CoreContainer)ReflectionUtils.invokeMethod((Method)createAndLoadMethod, null, (Object[])new Object[]{solrHomeDirectory, solrXmlFile});
        }
        createAndLoadMethod = ClassUtils.getStaticMethod(CoreContainer.class, (String)"createAndLoad", (Class[])new Class[]{Path.class, Path.class});
        return (CoreContainer)ReflectionUtils.invokeMethod((Method)createAndLoadMethod, null, (Object[])new Object[]{FileSystems.getDefault().getPath(solrHomeDirectory, new String[0]), FileSystems.getDefault().getPath(solrXmlFile.getPath(), new String[0])});
    }

    public void shutdownSolrServer() {
        if (this.coreContainer.get() != null) {
            this.coreContainer.get().shutdown();
        }
    }

    public List<String> getCores() {
        return new ArrayList<String>(this.getCoreContainer().getAllCoreNames());
    }

    public void setSolrHome(String solrHome) {
        Assert.hasText((String)solrHome, (String)"SolrHome must not be null nor empty!");
        this.solrHome = solrHome;
    }

    public void destroy() throws Exception {
        this.shutdownSolrServer();
    }

    private CoreContainer getCoreContainer() {
        if (this.coreContainer.get() == null) {
            this.initCoreContainer();
        }
        return this.coreContainer.get();
    }
}

