/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.util.Assert;

public class ProductFunction
extends AbstractFunction {
    private static final String OPERATION = "product";

    private ProductFunction(Object value) {
        super(Arrays.asList(value));
    }

    public static Builder product(Number value) {
        return new Builder(value);
    }

    public static Builder product(Field field) {
        Assert.notNull((Object)field, (String)"Field must not be 'null'");
        return ProductFunction.product(field.getName());
    }

    public static Builder product(String fieldname) {
        return new Builder(fieldname);
    }

    public static Builder product(Function function) {
        return new Builder(function);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private ProductFunction function;

        public Builder(String fieldname) {
            Assert.hasText((String)fieldname, (String)"Fieldname must not be 'empty'.");
            this.function = new ProductFunction(fieldname);
        }

        public Builder(Number value) {
            Assert.notNull((Object)value, (String)"Argument 'value' must not be 'null'.");
            this.function = new ProductFunction(value);
        }

        public Builder(Function function) {
            Assert.notNull((Object)function, (String)"Argument 'function' must not be 'null'.");
            this.function = new ProductFunction(function);
        }

        public Builder times(Field field) {
            Assert.notNull((Object)field, (String)"Argument 'field' must not be 'null'.");
            return this.times(field.getName());
        }

        public Builder times(String fieldname) {
            Assert.hasText((String)fieldname, (String)"Fieldname must not be 'empty'.");
            this.function.addArgument(fieldname);
            return this;
        }

        public Builder times(Number value) {
            Assert.notNull((Object)value, (String)"Argument 'value' must not be 'null'.");
            this.function.addArgument(value);
            return this;
        }

        public Builder times(Function function) {
            Assert.notNull((Object)function, (String)"Argument 'function' must not be 'null'.");
            this.function.addArgument(function);
            return this;
        }

        public ProductFunction build() {
            return this.function;
        }
    }
}

