/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.convert.GeoIndexedPropertyValue;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

class RedisQueryEngine
extends QueryEngine<RedisKeyValueAdapter, RedisOperationChain, Comparator<?>> {
    RedisQueryEngine() {
        this(new RedisCriteriaAccessor(), null);
    }

    private RedisQueryEngine(CriteriaAccessor<RedisOperationChain> criteriaAccessor, @Nullable SortAccessor<Comparator<?>> sortAccessor) {
        super(criteriaAccessor, sortAccessor);
    }

    public <T> Collection<T> execute(RedisOperationChain criteria, Comparator<?> sort, long offset, int rows, String keyspace, Class<T> type) {
        if (criteria == null || CollectionUtils.isEmpty(criteria.getOrSismember()) && CollectionUtils.isEmpty(criteria.getSismember()) && criteria.getNear() == null) {
            return ((RedisKeyValueAdapter)this.getAdapter()).getAllOf(keyspace, offset, rows);
        }
        RedisCallback<Map> callback = connection -> {
            List<Object> allKeys = new ArrayList<Object>();
            if (!criteria.getSismember().isEmpty()) {
                allKeys.addAll(connection.sInter(this.keys(keyspace + ":", criteria.getSismember())));
            }
            if (!criteria.getOrSismember().isEmpty()) {
                allKeys.addAll(connection.sUnion(this.keys(keyspace + ":", criteria.getOrSismember())));
            }
            if (criteria.getNear() != null) {
                GeoResults<RedisGeoCommands.GeoLocation<byte[]>> x = connection.geoRadius(this.geoKey(keyspace + ":", criteria.getNear()), new Circle(criteria.getNear().getPoint(), criteria.getNear().getDistance()));
                for (GeoResult y : x) {
                    allKeys.add(((RedisGeoCommands.GeoLocation)y.getContent()).getName());
                }
            }
            byte[] keyspaceBin = (byte[])((RedisKeyValueAdapter)this.getAdapter()).getConverter().getConversionService().convert((Object)(keyspace + ":"), byte[].class);
            LinkedHashMap<byte[], Map<byte[], byte[]>> rawData = new LinkedHashMap<byte[], Map<byte[], byte[]>>();
            if (allKeys.isEmpty() || (long)allKeys.size() < offset) {
                return Collections.emptyMap();
            }
            int offsetToUse = Math.max(0, (int)offset);
            if (rows > 0) {
                allKeys = allKeys.subList(Math.max(0, offsetToUse), Math.min(offsetToUse + rows, allKeys.size()));
            }
            for (byte[] id : allKeys) {
                byte[] singleKey = ByteUtils.concat(keyspaceBin, id);
                rawData.put(id, connection.hGetAll(singleKey));
            }
            return rawData;
        };
        Map raw = ((RedisKeyValueAdapter)this.getAdapter()).execute(callback);
        ArrayList<Object> result = new ArrayList<Object>(raw.size());
        for (Map.Entry entry : raw.entrySet()) {
            RedisData data = new RedisData((Map)entry.getValue());
            data.setId((String)((RedisKeyValueAdapter)this.getAdapter()).getConverter().getConversionService().convert(entry.getKey(), String.class));
            data.setKeyspace(keyspace);
            Object converted = ((RedisKeyValueAdapter)this.getAdapter()).getConverter().read(type, data);
            if (converted == null) continue;
            result.add(converted);
        }
        return result;
    }

    public Collection<?> execute(RedisOperationChain criteria, Comparator<?> sort, long offset, int rows, String keyspace) {
        return this.execute(criteria, sort, offset, rows, keyspace, Object.class);
    }

    public long count(RedisOperationChain criteria, String keyspace) {
        if (criteria == null) {
            return ((RedisKeyValueAdapter)this.getAdapter()).count(keyspace);
        }
        return ((RedisKeyValueAdapter)this.getAdapter()).execute(connection -> {
            String key = keyspace + ":";
            byte[][] keys = new byte[criteria.getSismember().size()][];
            int i = 0;
            for (RedisOperationChain.PathAndValue o : criteria.getSismember()) {
                keys[i] = (byte[])((RedisKeyValueAdapter)this.getAdapter()).getConverter().getConversionService().convert((Object)(key + o), byte[].class);
            }
            return connection.sInter(keys).size();
        });
    }

    private byte[][] keys(String prefix, Collection<RedisOperationChain.PathAndValue> source) {
        byte[][] keys = new byte[source.size()][];
        int i = 0;
        for (RedisOperationChain.PathAndValue pathAndValue : source) {
            byte[] convertedValue = (byte[])((RedisKeyValueAdapter)this.getAdapter()).getConverter().getConversionService().convert(pathAndValue.getFirstValue(), byte[].class);
            byte[] fullPath = (byte[])((RedisKeyValueAdapter)this.getAdapter()).getConverter().getConversionService().convert((Object)(prefix + pathAndValue.getPath() + ":"), byte[].class);
            keys[i] = ByteUtils.concat(fullPath, convertedValue);
            ++i;
        }
        return keys;
    }

    private byte[] geoKey(String prefix, RedisOperationChain.NearPath source) {
        String path = GeoIndexedPropertyValue.geoIndexName(source.getPath());
        return (byte[])((RedisKeyValueAdapter)this.getAdapter()).getConverter().getConversionService().convert((Object)(prefix + path), byte[].class);
    }

    static class RedisCriteriaAccessor
    implements CriteriaAccessor<RedisOperationChain> {
        RedisCriteriaAccessor() {
        }

        public RedisOperationChain resolve(KeyValueQuery<?> query) {
            return (RedisOperationChain)query.getCriteria();
        }
    }
}

