/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;

class LettuceZSetCommands
implements RedisZSetCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zadd((Object)key, score, (Object)value), LettuceConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zadd((Object)key, score, (Object)value), LettuceConverters.longToBoolean()));
                return null;
            }
            return LettuceConverters.toBoolean(this.getConnection().zadd((Object)key, score, (Object)value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zadd((Object)key, LettuceConverters.toObjects(tuples).toArray())));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zadd((Object)key, LettuceConverters.toObjects(tuples).toArray())));
                return null;
            }
            return this.getConnection().zadd((Object)key, LettuceConverters.toObjects(tuples).toArray());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zrem((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zrem((Object)key, (Object[])values)));
                return null;
            }
            return this.getConnection().zrem((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zincrby((Object)key, increment, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zincrby((Object)key, increment, (Object)value)));
                return null;
            }
            return this.getConnection().zincrby((Object)key, increment, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zrank((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zrank((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().zrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zrevrank((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zrevrank((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().zrevrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toTupleSet(this.getConnection().zrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrange((Object)key, start, end), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrevrange((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangeWithScores((Object)key, start, end), LettuceConverters.scoredValuesToTupleSet()));
                return null;
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrevrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore((Object)key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore((Object)key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscore((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toBytesSet(this.getConnection().zrevrangebyscore((Object)key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrevrangebyscore((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range)), LettuceConverters.scoredValuesToTupleSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.scoredValuesToTupleSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toTupleSet(this.getConnection().zrevrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toTupleSet(this.getConnection().zrevrangebyscoreWithScores((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zcount((Object)key, LettuceConverters.toRange(range))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zcount((Object)key, LettuceConverters.toRange(range))));
                return null;
            }
            return this.getConnection().zcount((Object)key, LettuceConverters.toRange(range));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zcard((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zcard((Object)key)));
                return null;
            }
            return this.getConnection().zcard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zscore((Object)key, (Object)value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zscore((Object)key, (Object)value)));
                return null;
            }
            return this.getConnection().zscore((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zremrangebyrank((Object)key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zremrangebyrank((Object)key, start, end)));
                return null;
            }
            return this.getConnection().zremrangebyrank((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREMRANGEBYSCORE must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zremrangebyscore((Object)key, LettuceConverters.toRange(range))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zremrangebyscore((Object)key, LettuceConverters.toRange(range))));
                return null;
            }
            return this.getConnection().zremrangebyscore((Object)key, LettuceConverters.toRange(range));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        ZStoreArgs storeArgs = this.zStoreArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            return this.getConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zunionstore((Object)destKey, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zunionstore((Object)destKey, (Object[])sets)));
                return null;
            }
            return this.getConnection().zunionstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        ZStoreArgs storeArgs = this.zStoreArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets)));
                return null;
            }
            return this.getConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zinterstore((Object)destKey, (Object[])sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().zinterstore((Object)destKey, (Object[])sets)));
                return null;
            }
            return this.getConnection().zinterstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId, options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceZSetCommands.this.isQueueing() || LettuceZSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanCursor scanCursor = LettuceZSetCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceZSetCommands.this.connection.getScanArgs(options);
                ScoredValueScanCursor scoredValueScanCursor = LettuceZSetCommands.this.getConnection().zscan((Object)key, scanCursor, scanArgs);
                String nextCursorId = scoredValueScanCursor.getCursor();
                List result = scoredValueScanCursor.getValues();
                List values = (List)LettuceZSetCommands.this.connection.failsafeReadScanValues(result, LettuceConverters.scoredValuesToTupleList());
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(nextCursorId), values);
            }

            @Override
            protected void doClose() {
                LettuceZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, min, max), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, min, max), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, min, max, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, min, max, offset, count), LettuceConverters.bytesListToBytesSet()));
                return null;
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore((Object)key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebyscore((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore((Object)key, LettuceConverters.toRange(range)));
            }
            return LettuceConverters.toBytesSet(this.getConnection().zrangebyscore((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYLEX must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        try {
            if (this.isPipelined()) {
                if (limit.isUnlimited()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex((Object)key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit.isUnlimited()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex((Object)key, LettuceConverters.toRange(range)), LettuceConverters.bytesListToBytesSet()));
                } else {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().zrangebylex((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)), LettuceConverters.bytesListToBytesSet()));
                }
                return null;
            }
            if (limit.isUnlimited()) {
                return (Set)LettuceConverters.bytesListToBytesSet().convert((Object)this.getConnection().zrangebylex((Object)key, LettuceConverters.toRange(range)));
            }
            return (Set)LettuceConverters.bytesListToBytesSet().convert((Object)this.getConnection().zrangebylex((Object)key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    private ZStoreArgs zStoreArgs(RedisZSetCommands.Aggregate aggregate, int[] weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        double[] lg = new double[weights.length];
        for (int i = 0; i < lg.length; ++i) {
            lg[i] = weights[i];
        }
        args.weights(lg);
        return args;
    }

    @ConstructorProperties(value={"connection"})
    public LettuceZSetCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

