/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.NonNull;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.BinaryJedis;

class JedisClusterServerCommands
implements RedisClusterServerCommands {
    @NonNull
    private final JedisClusterConnection connection;

    @Override
    public void bgReWriteAof(RedisClusterNode node) {
        this.executeCommandOnSingleNode(BinaryJedis::bgrewriteaof, node);
    }

    @Override
    public void bgReWriteAof() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::bgrewriteaof);
    }

    @Override
    public void bgSave() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::bgsave);
    }

    @Override
    public void bgSave(RedisClusterNode node) {
        this.executeCommandOnSingleNode(BinaryJedis::bgsave, node);
    }

    @Override
    public Long lastSave() {
        ArrayList result = new ArrayList(this.executeCommandOnAllNodes(BinaryJedis::lastsave).resultsAsList());
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        Collections.sort(result, Collections.reverseOrder());
        return (Long)result.get(0);
    }

    @Override
    public Long lastSave(RedisClusterNode node) {
        return (Long)this.executeCommandOnSingleNode(BinaryJedis::lastsave, node).getValue();
    }

    @Override
    public void save() {
        this.executeCommandOnAllNodes(BinaryJedis::save);
    }

    @Override
    public void save(RedisClusterNode node) {
        this.executeCommandOnSingleNode(BinaryJedis::save, node);
    }

    @Override
    public Long dbSize() {
        List dbSizes = this.executeCommandOnAllNodes(BinaryJedis::dbSize).resultsAsList();
        if (CollectionUtils.isEmpty(dbSizes)) {
            return 0L;
        }
        Long size = 0L;
        for (Long value : dbSizes) {
            size = size + value;
        }
        return size;
    }

    @Override
    public Long dbSize(RedisClusterNode node) {
        return (Long)this.executeCommandOnSingleNode(BinaryJedis::dbSize, node).getValue();
    }

    @Override
    public void flushDb() {
        this.executeCommandOnAllNodes(BinaryJedis::flushDB);
    }

    @Override
    public void flushDb(RedisClusterNode node) {
        this.executeCommandOnSingleNode(BinaryJedis::flushDB, node);
    }

    @Override
    public void flushAll() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::flushAll);
    }

    @Override
    public void flushAll(RedisClusterNode node) {
        this.executeCommandOnSingleNode(BinaryJedis::flushAll, node);
    }

    @Override
    public Properties info() {
        Properties infos = new Properties();
        List nodeResults = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> JedisConverters.toProperties(client.info())).getResults();
        for (ClusterCommandExecutor.NodeResult nodeProperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : ((Properties)nodeProperties.getValue()).entrySet()) {
                infos.put(nodeProperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(RedisClusterNode node) {
        return JedisConverters.toProperties((String)this.executeCommandOnSingleNode(BinaryJedis::info, node).getValue());
    }

    @Override
    public Properties info(String section) {
        Assert.notNull((Object)section, (String)"Section must not be null!");
        Properties infos = new Properties();
        List nodeResults = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> JedisConverters.toProperties(client.info(section))).getResults();
        for (ClusterCommandExecutor.NodeResult nodeProperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : ((Properties)nodeProperties.getValue()).entrySet()) {
                infos.put(nodeProperties.getNode().asString() + "." + entry.getKey(), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(RedisClusterNode node, String section) {
        Assert.notNull((Object)section, (String)"Section must not be null!");
        return JedisConverters.toProperties((String)this.executeCommandOnSingleNode(client -> client.info(section), node).getValue());
    }

    @Override
    public void shutdown() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::shutdown);
    }

    @Override
    public void shutdown(RedisClusterNode node) {
        this.executeCommandOnSingleNode(BinaryJedis::shutdown, node);
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        throw new IllegalArgumentException("Shutdown with options is not supported for jedis.");
    }

    @Override
    public Properties getConfig(String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        List mapResult = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> client.configGet(pattern)).getResults();
        ArrayList<String> result = new ArrayList<String>();
        for (ClusterCommandExecutor.NodeResult entry : mapResult) {
            String prefix = entry.getNode().asString();
            int i = 0;
            for (String value : (List)entry.getValue()) {
                result.add((i++ % 2 == 0 ? prefix + "." : "") + value);
            }
        }
        return Converters.toProperties(result);
    }

    @Override
    public Properties getConfig(RedisClusterNode node, String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        return (Properties)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode((S client) -> Converters.toProperties(client.configGet(pattern)), node).getValue();
    }

    @Override
    public void setConfig(String param, String value) {
        Assert.notNull((Object)param, (String)"Parameter must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> client.configSet(param, value));
    }

    @Override
    public void setConfig(RedisClusterNode node, String param, String value) {
        Assert.notNull((Object)param, (String)"Parameter must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.executeCommandOnSingleNode(client -> client.configSet(param, value), node);
    }

    @Override
    public void resetConfigStats() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::configResetStat);
    }

    @Override
    public void resetConfigStats(RedisClusterNode node) {
        this.executeCommandOnSingleNode(BinaryJedis::configResetStat, node);
    }

    @Override
    public Long time() {
        return this.convertListOfStringToTime((List)this.connection.getClusterCommandExecutor().executeCommandOnArbitraryNode(BinaryJedis::time).getValue());
    }

    @Override
    public Long time(RedisClusterNode node) {
        return this.convertListOfStringToTime((List)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(BinaryJedis::time, node).getValue());
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        String hostAndPort = String.format("%s:%s", host, port);
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> client.clientKill(hostAndPort));
    }

    @Override
    public void setClientName(byte[] name) {
        throw new InvalidDataAccessApiUsageException("CLIENT SETNAME is not supported in cluster environment.");
    }

    @Override
    public String getClientName() {
        throw new InvalidDataAccessApiUsageException("CLIENT GETNAME is not supported in cluster environment.");
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        List map = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(BinaryJedis::clientList).resultsAsList();
        ArrayList<RedisClientInfo> result = new ArrayList<RedisClientInfo>();
        for (String infos : map) {
            result.addAll(JedisConverters.toListOfRedisClientInformation(infos));
        }
        return result;
    }

    @Override
    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        return JedisConverters.toListOfRedisClientInformation((String)this.executeCommandOnSingleNode(BinaryJedis::clientList, node).getValue());
    }

    @Override
    public void slaveOf(String host, int port) {
        throw new InvalidDataAccessApiUsageException("SlaveOf is not supported in cluster environment. Please use CLUSTER REPLICATE.");
    }

    @Override
    public void slaveOfNoOne() {
        throw new InvalidDataAccessApiUsageException("SlaveOf is not supported in cluster environment. Please use CLUSTER REPLICATE.");
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)target, (String)"Target node must not be null!");
        int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        RedisClusterNode node = this.connection.getTopologyProvider().getTopology().lookup(target.getHost(), target.getPort());
        this.executeCommandOnSingleNode(client -> client.migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse), node);
    }

    private Long convertListOfStringToTime(List<String> serverTimeInformation) {
        Assert.notEmpty(serverTimeInformation, (String)"Received invalid result from server. Expected 2 items in collection.");
        Assert.isTrue((serverTimeInformation.size() == 2 ? 1 : 0) != 0, (String)("Received invalid number of arguments from redis server. Expected 2 received " + serverTimeInformation.size()));
        return Converters.toTimeMillis(serverTimeInformation.get(0), serverTimeInformation.get(1));
    }

    private <T> ClusterCommandExecutor.NodeResult<T> executeCommandOnSingleNode(JedisClusterConnection.JedisClusterCommandCallback<T> cmd, RedisClusterNode node) {
        return this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(cmd, node);
    }

    private <T> ClusterCommandExecutor.MultiNodeResult<T> executeCommandOnAllNodes(JedisClusterConnection.JedisClusterCommandCallback<T> cmd) {
        return this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(cmd);
    }

    @ConstructorProperties(value={"connection"})
    public JedisClusterServerCommands(@NonNull JedisClusterConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

