/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisScriptReturnConverter;
import org.springframework.util.Assert;

class JedisScriptingCommands
implements RedisScriptingCommands {
    @NonNull
    private final JedisConnection connection;

    @Override
    public void scriptFlush() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.connection.getJedis().scriptFlush();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void scriptKill() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            this.connection.getJedis().scriptKill();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String scriptLoad(byte[] script) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return JedisConverters.toString(this.connection.getJedis().scriptLoad(script));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Boolean> scriptExists(String ... scriptSha1) {
        Assert.notNull((Object)scriptSha1, (String)"Script digests must not be null!");
        Assert.noNullElements((Object[])scriptSha1, (String)"Script digests must not contain null elements!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return this.connection.getJedis().scriptExists(scriptSha1);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)script, (String)"Script must not be null!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return (T)new JedisScriptReturnConverter(returnType).convert(this.connection.getJedis().eval(script, JedisConverters.toBytes(numKeys), keysAndArgs));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public <T> T evalSha(String scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        return this.evalSha(JedisConverters.toBytes(scriptSha1), returnType, numKeys, keysAndArgs);
    }

    @Override
    public <T> T evalSha(byte[] scriptSha1, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        Assert.notNull((Object)scriptSha1, (String)"Script digest must not be null!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        try {
            return (T)new JedisScriptReturnConverter(returnType).convert(this.connection.getJedis().evalsha(scriptSha1, numKeys, keysAndArgs));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    @ConstructorProperties(value={"connection"})
    public JedisScriptingCommands(@NonNull JedisConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

