/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.beans.ConstructorProperties;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.convert.IndexedData;

public class GeoIndexedPropertyValue
implements IndexedData {
    private final String keyspace;
    private final String indexName;
    private final Point value;

    @Override
    public String getIndexName() {
        return GeoIndexedPropertyValue.geoIndexName(this.indexName);
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public Point getPoint() {
        return this.value;
    }

    public static String geoIndexName(String path) {
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path);
        sb.setCharAt(index, ':');
        return sb.toString();
    }

    @ConstructorProperties(value={"keyspace", "indexName", "value"})
    public GeoIndexedPropertyValue(String keyspace, String indexName, Point value) {
        this.keyspace = keyspace;
        this.indexName = indexName;
        this.value = value;
    }

    public Point getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoIndexedPropertyValue)) {
            return false;
        }
        GeoIndexedPropertyValue other = (GeoIndexedPropertyValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$keyspace = this.getKeyspace();
        String other$keyspace = other.getKeyspace();
        if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        Point this$value = this.getValue();
        Point other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoIndexedPropertyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyspace = this.getKeyspace();
        result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        Point $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "GeoIndexedPropertyValue(keyspace=" + this.getKeyspace() + ", indexName=" + this.getIndexName() + ", value=" + this.getValue() + ")";
    }
}

