/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisURI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.util.Assert;

public class DefaultLettucePool
implements LettucePool,
InitializingBean {
    private GenericObjectPool<RedisAsyncConnection> internalPool;
    private RedisClient client;
    private int dbIndex = 0;
    private GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
    private String hostName = "localhost";
    private int port = 6379;
    private String password;
    private long timeout = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private RedisSentinelConfiguration sentinelConfiguration;

    public DefaultLettucePool() {
    }

    public DefaultLettucePool(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public DefaultLettucePool(RedisSentinelConfiguration sentinelConfiguration) {
        this.sentinelConfiguration = sentinelConfiguration;
    }

    public DefaultLettucePool(String hostName, int port, GenericObjectPoolConfig poolConfig) {
        this.hostName = hostName;
        this.port = port;
        this.poolConfig = poolConfig;
    }

    public boolean isRedisSentinelAware() {
        return this.sentinelConfiguration != null;
    }

    public void afterPropertiesSet() {
        this.client = new RedisClient(this.getRedisURI());
        this.client.setDefaultTimeout(this.timeout, TimeUnit.MILLISECONDS);
        this.internalPool = new GenericObjectPool((PooledObjectFactory)new LettuceFactory(this.client, this.dbIndex), this.poolConfig);
    }

    private RedisURI getRedisURI() {
        if (this.isRedisSentinelAware()) {
            return LettuceConverters.sentinelConfigurationToRedisURI(this.sentinelConfiguration);
        }
        return this.createSimpleHostRedisURI();
    }

    private RedisURI createSimpleHostRedisURI() {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)this.hostName, (int)this.port);
        if (this.password != null) {
            builder.withPassword(this.password);
        }
        builder.withTimeout(this.timeout, TimeUnit.MILLISECONDS);
        return builder.build();
    }

    @Override
    public RedisAsyncConnection<byte[], byte[]> getResource() {
        try {
            return (RedisAsyncConnection)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    @Override
    public void returnBrokenResource(RedisAsyncConnection<byte[], byte[]> resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not invalidate the broken resource", e);
        }
    }

    @Override
    public void returnResource(RedisAsyncConnection<byte[], byte[]> resource) {
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not return the resource to the pool", e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.client.shutdown();
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new PoolException("Could not destroy the pool", e);
        }
    }

    @Override
    public RedisClient getClient() {
        return this.client;
    }

    public GenericObjectPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String host) {
        this.hostName = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private static class LettuceFactory
    extends BasePooledObjectFactory<RedisAsyncConnection> {
        private final RedisClient client;
        private int dbIndex;

        public LettuceFactory(RedisClient client, int dbIndex) {
            this.client = client;
            this.dbIndex = dbIndex;
        }

        public void activateObject(PooledObject<RedisAsyncConnection> pooledObject) throws Exception {
            ((RedisAsyncConnection)pooledObject.getObject()).select(this.dbIndex);
        }

        public void destroyObject(PooledObject<RedisAsyncConnection> obj) throws Exception {
            try {
                ((RedisAsyncConnection)obj.getObject()).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean validateObject(PooledObject<RedisAsyncConnection> obj) {
            try {
                ((RedisAsyncConnection)obj.getObject()).ping();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public RedisAsyncConnection create() throws Exception {
            return this.client.connectAsync(LettuceConnection.CODEC);
        }

        public PooledObject<RedisAsyncConnection> wrap(RedisAsyncConnection obj) {
            return new DefaultPooledObject((Object)obj);
        }
    }
}

