/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultSetOperations<K, V>
extends AbstractOperations<K, V>
implements SetOperations<K, V> {
    public DefaultSetOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Long add(K key, V ... values) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawValues = this.rawValues(values);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.sAdd(rawKey, rawValues);
            }
        }, true);
    }

    @Override
    public Set<V> difference(K key, K otherKey) {
        return this.difference(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Set<V> difference(K key, Collection<K> otherKeys) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.sDiff(rawKeys);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long differenceAndStore(K key, K otherKey, K destKey) {
        return this.differenceAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        final byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.sDiffStore(rawDestKey, rawKeys);
            }
        }, true);
    }

    @Override
    public Set<V> intersect(K key, K otherKey) {
        return this.intersect(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Set<V> intersect(K key, Collection<K> otherKeys) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.sInter(rawKeys);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long intersectAndStore(K key, K otherKey, K destKey) {
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        final byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                connection.sInterStore(rawDestKey, rawKeys);
                return null;
            }
        }, true);
    }

    @Override
    public Boolean isMember(K key, Object o) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawValue = this.rawValue(o);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.sIsMember(rawKey, rawValue);
            }
        }, true);
    }

    @Override
    public Set<V> members(K key) {
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.sMembers(rawKey);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Boolean move(K key, V value, K destKey) {
        final byte[] rawKey = this.rawKey(key);
        final byte[] rawDestKey = this.rawKey(destKey);
        final byte[] rawValue = this.rawValue(value);
        return this.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) {
                return connection.sMove(rawKey, rawDestKey, rawValue);
            }
        }, true);
    }

    @Override
    public V randomMember(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.sRandMember(rawKey);
            }
        }, true);
    }

    @Override
    public Set<V> distinctRandomMembers(K key, final long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative count not supported. Use randomMembers to allow duplicate elements.");
        }
        final byte[] rawKey = this.rawKey(key);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return new HashSet<byte[]>(connection.sRandMember(rawKey, count));
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public List<V> randomMembers(K key, final long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Use a positive number for count. This method is already allowing duplicate elements.");
        }
        final byte[] rawKey = this.rawKey(key);
        List<byte[]> rawValues = this.execute(new RedisCallback<List<byte[]>>(){

            @Override
            public List<byte[]> doInRedis(RedisConnection connection) {
                return connection.sRandMember(rawKey, -count);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long remove(K key, Object ... values) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawValues = this.rawValues(values);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.sRem(rawKey, rawValues);
            }
        }, true);
    }

    @Override
    public V pop(K key) {
        return (V)this.execute(new AbstractOperations.ValueDeserializingRedisCallback(key){

            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.sPop(rawKey);
            }
        }, true);
    }

    @Override
    public Long size(K key) {
        final byte[] rawKey = this.rawKey(key);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.sCard(rawKey);
            }
        }, true);
    }

    @Override
    public Set<V> union(K key, K otherKey) {
        return this.union(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Set<V> union(K key, Collection<K> otherKeys) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set<byte[]> rawValues = this.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) {
                return connection.sUnion(rawKeys);
            }
        }, true);
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long unionAndStore(K key, K otherKey, K destKey) {
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        final byte[][] rawKeys = this.rawKeys(key, otherKeys);
        final byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) {
                return connection.sUnionStore(rawDestKey, rawKeys);
            }
        }, true);
    }
}

