/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jredis;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.jredis.JRedis;
import org.jredis.connector.Connection;
import org.jredis.connector.ConnectionSpec;
import org.jredis.ri.alphazero.JRedisClient;
import org.jredis.ri.alphazero.connection.DefaultConnectionSpec;
import org.springframework.data.redis.connection.Pool;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JredisPool
implements Pool<JRedis> {
    private final GenericObjectPool internalPool;

    public JredisPool(String hostName, int port) {
        this(hostName, port, 0, null, 0, new GenericObjectPool.Config());
    }

    public JredisPool(String hostName, int port, GenericObjectPool.Config poolConfig) {
        this(hostName, port, 0, null, 0, poolConfig);
    }

    public JredisPool(ConnectionSpec connectionSpec) {
        this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JredisFactory(connectionSpec), new GenericObjectPool.Config());
    }

    public JredisPool(ConnectionSpec connectionSpec, GenericObjectPool.Config poolConfig) {
        this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JredisFactory(connectionSpec), poolConfig);
    }

    public JredisPool(String hostName, int port, int dbIndex, String password, int timeout) {
        this(hostName, port, dbIndex, password, timeout, new GenericObjectPool.Config());
    }

    public JredisPool(String hostName, int port, int dbIndex, String password, int timeout, GenericObjectPool.Config poolConfig) {
        ConnectionSpec connectionSpec = DefaultConnectionSpec.newSpec((String)hostName, (int)port, (int)dbIndex, null);
        connectionSpec.setConnectionFlag(Connection.Flag.RELIABLE, Boolean.valueOf(false));
        if (StringUtils.hasLength((String)password)) {
            connectionSpec.setCredentials(password);
        }
        if (timeout > 0) {
            connectionSpec.setSocketProperty(Connection.Socket.Property.SO_TIMEOUT, Integer.valueOf(timeout));
        }
        this.internalPool = new GenericObjectPool((PoolableObjectFactory)new JredisFactory(connectionSpec), poolConfig);
    }

    @Override
    public JRedis getResource() {
        try {
            return (JRedis)this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new PoolException("Could not get a resource from the pool", e);
        }
    }

    @Override
    public void returnBrokenResource(JRedis resource) {
        try {
            this.internalPool.invalidateObject((Object)resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not invalidate the broken resource", e);
        }
    }

    @Override
    public void returnResource(JRedis resource) {
        try {
            this.internalPool.returnObject((Object)resource);
        }
        catch (Exception e) {
            throw new PoolException("Could not return the resource to the pool", e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new PoolException("Could not destroy the pool", e);
        }
    }

    private static class JredisFactory
    extends BasePoolableObjectFactory {
        private final ConnectionSpec connectionSpec;

        public JredisFactory(ConnectionSpec connectionSpec) {
            this.connectionSpec = connectionSpec;
        }

        public Object makeObject() throws Exception {
            return new JRedisClient(this.connectionSpec);
        }

        public void destroyObject(Object obj) throws Exception {
            if (obj instanceof JRedis) {
                try {
                    ((JRedis)obj).quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean validateObject(Object obj) {
            if (obj instanceof JRedis) {
                try {
                    ((JRedis)obj).ping();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
    }
}

