/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.rjc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.idevlab.rjc.Client;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.Session;
import org.idevlab.rjc.SessionFactoryImpl;
import org.idevlab.rjc.SortingParams;
import org.idevlab.rjc.ZParams;
import org.idevlab.rjc.ds.DataSource;
import org.idevlab.rjc.message.RedisNodeSubscriber;
import org.idevlab.rjc.protocol.Protocol;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.rjc.CloseSuppressingRjcConnection;
import org.springframework.data.redis.connection.rjc.RjcSubscription;
import org.springframework.data.redis.connection.rjc.RjcUtils;
import org.springframework.data.redis.connection.rjc.SingleDataSource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RjcConnection
implements RedisConnection {
    private final int dbIndex;
    private boolean isClosed = false;
    private final Client client;
    private final Session session;
    private final org.idevlab.rjc.ds.RedisConnection connection;
    private volatile Client pipeline;
    private volatile RjcSubscription subscription;
    private volatile RedisNodeSubscriber subscriber;

    public RjcConnection(org.idevlab.rjc.ds.RedisConnection connection, int dbIndex) {
        this(connection, dbIndex, new RedisNodeSubscriber((DataSource)new SingleDataSource(new CloseSuppressingRjcConnection(connection))));
    }

    public RjcConnection(org.idevlab.rjc.ds.RedisConnection connection, int dbIndex, RedisNodeSubscriber subscriber) {
        SingleDataSource connectionDataSource = new SingleDataSource(connection);
        this.session = new SessionFactoryImpl((DataSource)connectionDataSource).create();
        this.subscriber = subscriber;
        this.client = new Client(connection);
        this.connection = connection;
        this.dbIndex = dbIndex;
        if (dbIndex > 0) {
            this.select(dbIndex);
        }
    }

    protected DataAccessException convertRjcAccessException(Exception ex) {
        if (ex instanceof RedisException) {
            return RjcUtils.convertRjcAccessException((RedisException)ex);
        }
        return new RedisSystemException("Unknown rjc exception", ex);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            this.connection.sendCommand(Protocol.Command.valueOf((String)command.trim().toUpperCase()), ObjectUtils.isEmpty((Object[])args) ? new byte[0][0] : args);
            if (!this.isPipelined()) {
                return this.connection.getAll();
            }
            return null;
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void close() throws DataAccessException {
        this.isClosed = true;
        if (this.dbIndex > 0) {
            this.select(0);
        }
        try {
            this.subscriber.close();
            this.session.close();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public Session getNativeConnection() {
        return this.session;
    }

    @Override
    public boolean isQueueing() {
        return this.client.isInMulti();
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        if (this.pipeline == null) {
            this.pipeline = this.client;
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (this.pipeline != null) {
            this.pipeline = null;
            try {
                return RjcUtils.maybeConvert(this.client.getAll());
            }
            catch (Exception ex) {
                throw new RedisPipelineException((Exception)this.convertRjcAccessException(ex));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortingParams sortParams = RjcUtils.convertSortParams(params);
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline.sort(stringKey, sortParams);
                } else {
                    this.pipeline.sort(stringKey);
                }
                return null;
            }
            return RjcUtils.convertToList(sortParams != null ? this.session.sort(stringKey, sortParams) : this.session.sort(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        SortingParams sortParams = RjcUtils.convertSortParams(params);
        String stringKey = RjcUtils.decode(key);
        String stringSortKey = RjcUtils.decode(sortKey);
        try {
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline.sort(stringKey, sortParams, stringSortKey);
                } else {
                    this.pipeline.sort(stringKey, stringSortKey);
                }
                return null;
            }
            return sortParams != null ? this.session.sort(stringKey, sortParams, stringSortKey) : this.session.sort(stringKey, stringSortKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline.dbSize();
                return null;
            }
            return this.session.dbSize();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline.flushDB();
                return;
            }
            this.session.flushDB();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline.flushAll();
                return;
            }
            this.session.flushAll();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline.bgsave();
                return;
            }
            this.session.bgsave();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void bgWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline.bgrewriteaof();
                return;
            }
            this.session.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline.save();
                return;
            }
            this.session.save();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline.configGet(param);
                return null;
            }
            return this.session.configGet(param);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline.info();
                return null;
            }
            return RjcUtils.info(this.session.info());
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline.lastsave();
                return null;
            }
            return this.session.lastsave();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline.configSet(param, value);
                return;
            }
            this.session.configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline.configResetStat();
                return;
            }
            this.client.configResetStat();
            this.client.getStatusCodeReply();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.pipeline.shutdown();
                return;
            }
            this.session.shutdown();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        String stringMsg = RjcUtils.decode(message);
        try {
            if (this.isPipelined()) {
                this.pipeline.echo(stringMsg);
                return null;
            }
            return RjcUtils.encode(this.session.echo(stringMsg));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline.ping();
                return null;
            }
            return this.session.ping();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.del(stringKeys);
                return null;
            }
            return this.session.del(stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void discard() {
        try {
            if (this.isPipelined()) {
                this.pipeline.discard();
                return;
            }
            this.session.discard();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        try {
            if (this.isPipelined()) {
                this.pipeline.exec();
                return null;
            }
            return this.session.exec();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.exists(stringKey);
                return null;
            }
            return this.session.exists(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.expire(stringKey, (int)seconds);
                return null;
            }
            return this.session.expire(stringKey, (int)seconds);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.expireAt(stringKey, unixTime);
                return null;
            }
            return this.session.expireAt(stringKey, unixTime);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        String stringKey = RjcUtils.decode(pattern);
        try {
            if (this.isPipelined()) {
                this.pipeline.keys(stringKey);
                return null;
            }
            return RjcUtils.convertToSet(this.session.keys(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        try {
            if (this.isPipelined()) {
                this.pipeline.multi();
                return;
            }
            this.session.multi();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.persist(stringKey);
                return null;
            }
            return this.session.persist(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.move(stringKey, dbIndex);
                return null;
            }
            return this.session.move(stringKey, dbIndex);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline.randomKey();
                return null;
            }
            return RjcUtils.encode(this.session.randomKey());
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        String stringOldKey = RjcUtils.decode(oldName);
        String stringNewKey = RjcUtils.decode(newName);
        try {
            if (this.isPipelined()) {
                this.pipeline.rename(stringOldKey, stringNewKey);
                return;
            }
            this.session.rename(stringOldKey, stringNewKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        String stringOldKey = RjcUtils.decode(oldName);
        String stringNewKey = RjcUtils.decode(newName);
        try {
            if (this.isPipelined()) {
                this.pipeline.renamenx(stringOldKey, stringNewKey);
                return null;
            }
            return this.session.renamenx(stringOldKey, stringNewKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline.select(dbIndex);
                return;
            }
            this.session.select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.ttl(stringKey);
                return null;
            }
            return this.session.ttl(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.type(stringKey);
                return null;
            }
            return DataType.fromCode(this.session.type(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            if (this.isPipelined()) {
                this.pipeline.unwatch();
                return;
            }
            this.session.unwatch();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        if (this.isQueueing()) {
            return;
        }
        try {
            if (this.isPipelined()) {
                this.pipeline.watch(stringKeys);
                return;
            }
            this.session.watch(stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.get(stringKey);
                return null;
            }
            return RjcUtils.encode(this.session.get(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.set(stringKey, stringValue);
                return;
            }
            this.session.set(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.getSet(stringKey, stringValue);
                return null;
            }
            return RjcUtils.encode(this.session.getSet(stringKey, stringValue));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.append(stringKey, stringValue);
                return null;
            }
            return this.session.append(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.mget(stringKeys);
                return null;
            }
            return RjcUtils.convertToList(this.session.mget(stringKeys));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        String[] decodeMap = RjcUtils.flatten(tuples);
        try {
            if (this.isPipelined()) {
                this.pipeline.mset(decodeMap);
                return;
            }
            this.session.mset(decodeMap);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void mSetNX(Map<byte[], byte[]> tuples) {
        String[] decodeMap = RjcUtils.flatten(tuples);
        try {
            if (this.isPipelined()) {
                this.pipeline.msetnx(decodeMap);
                return;
            }
            this.session.msetnx(decodeMap);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.setex(stringKey, (int)time, stringValue);
                return;
            }
            this.session.setex(stringKey, (int)time, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.setnx(stringKey, stringValue);
                return null;
            }
            return this.session.setnx(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.getRange(stringKey, (int)start, (int)end);
                return null;
            }
            return RjcUtils.encode(this.session.getRange(stringKey, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.decr(stringKey);
                return null;
            }
            return this.session.decr(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.decrBy(stringKey, (int)value);
                return null;
            }
            return this.session.decrBy(stringKey, (int)value);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.incr(stringKey);
                return null;
            }
            return this.session.incr(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.incrBy(stringKey, (int)value);
                return null;
            }
            return this.session.incrBy(stringKey, (int)value);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.getbit(stringKey, (int)offset);
                return null;
            }
            return this.session.getBit(stringKey, (int)offset) == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.setbit(stringKey, (int)offset, RjcUtils.asBit(value));
                return;
            }
            this.session.setBit(stringKey, (int)offset, RjcUtils.asBit(value));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.setRange(stringKey, (int)offset, stringValue);
                return;
            }
            this.session.setRange(stringKey, (int)offset, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.strlen(stringKey);
                return null;
            }
            return this.session.strlen(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.lpush(stringKey, stringValue);
                return null;
            }
            return this.session.lpush(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.rpush(stringKey, stringValue);
                return null;
            }
            return this.session.rpush(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.blpop(stringKeys);
                return null;
            }
            return RjcUtils.convertToList(this.session.blpop(timeout, stringKeys));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.brpop(stringKeys);
                return null;
            }
            return RjcUtils.convertToList(this.session.brpop(timeout, stringKeys));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.lindex(stringKey, (int)index);
                return null;
            }
            return RjcUtils.encode(this.session.lindex(stringKey, (int)index));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        String stringPivot = RjcUtils.decode(pivot);
        Client.LIST_POSITION position = RjcUtils.convertPosition(where);
        try {
            if (this.isPipelined()) {
                this.pipeline.linsert(stringKey, position, stringPivot, stringValue);
                return null;
            }
            return this.session.linsert(stringKey, position, stringPivot, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.llen(stringKey);
                return null;
            }
            return this.session.llen(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.lpop(stringKey);
                return null;
            }
            return RjcUtils.encode(this.session.lpop(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.lrange(stringKey, (int)start, (int)end);
                return null;
            }
            return RjcUtils.convertToList(this.session.lrange(stringKey, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.lrem(stringKey, (int)count, stringValue);
                return null;
            }
            return this.session.lrem(stringKey, (int)count, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.lset(stringKey, (int)index, stringValue);
                return;
            }
            this.session.lset(stringKey, (int)index, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.ltrim(stringKey, (int)start, (int)end);
                return;
            }
            this.session.ltrim(stringKey, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.rpop(stringKey);
                return null;
            }
            return RjcUtils.encode(this.session.rpop(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        String stringKey = RjcUtils.decode(srcKey);
        String stringDest = RjcUtils.decode(dstKey);
        try {
            if (this.isPipelined()) {
                this.pipeline.rpoplpush(stringKey, stringDest);
                return null;
            }
            return RjcUtils.encode(this.session.rpoplpush(stringKey, stringDest));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        String stringKey = RjcUtils.decode(srcKey);
        String stringDest = RjcUtils.decode(dstKey);
        try {
            if (this.isPipelined()) {
                this.pipeline.brpoplpush(stringKey, stringDest, timeout);
                return null;
            }
            return RjcUtils.encode(this.session.brpoplpush(stringKey, stringDest, timeout));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.lpushx(stringKey, stringValue);
                return null;
            }
            return this.session.lpushx(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.rpushx(stringKey, stringValue);
                return null;
            }
            return this.session.rpushx(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean sAdd(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.sadd(stringKey, stringValue);
                return null;
            }
            return this.session.sadd(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.scard(stringKey);
                return null;
            }
            return this.session.scard(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.sdiff(stringKeys);
                return null;
            }
            return RjcUtils.convertToSet(this.session.sdiff(stringKeys));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        String stringKey = RjcUtils.decode(destKey);
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.sdiffstore(stringKey, stringKeys);
                return null;
            }
            return this.session.sdiffstore(stringKey, stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.sinter(stringKeys);
                return null;
            }
            return RjcUtils.convertToSet(this.session.sinter(stringKeys));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        String stringKey = RjcUtils.decode(destKey);
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.sinterstore(stringKey, stringKeys);
                return null;
            }
            return this.session.sinterstore(stringKey, stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.sismember(stringKey, stringValue);
                return null;
            }
            return this.session.sismember(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.smembers(stringKey);
                return null;
            }
            return RjcUtils.convertToSet(this.session.smembers(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        String stringSrc = RjcUtils.decode(srcKey);
        String stringDest = RjcUtils.decode(destKey);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.smove(stringSrc, stringDest, stringValue);
                return null;
            }
            return this.session.smove(stringSrc, stringDest, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.spop(stringKey);
                return null;
            }
            return RjcUtils.encode(this.session.spop(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.srandmember(stringKey);
                return null;
            }
            return RjcUtils.encode(this.session.srandmember(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean sRem(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.srem(stringKey, stringValue);
                return null;
            }
            return this.session.srem(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.sunion(stringKeys);
                return null;
            }
            return RjcUtils.convertToSet(this.session.sunion(stringKeys));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        String stringKey = RjcUtils.decode(destKey);
        String[] stringKeys = RjcUtils.decodeMultiple(keys);
        try {
            if (this.isPipelined()) {
                this.pipeline.sunionstore(stringKey, stringKeys);
                return null;
            }
            return this.session.sunionstore(stringKey, stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.zadd(stringKey, (Number)score, stringValue);
                return null;
            }
            return this.session.zadd(stringKey, (Number)score, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.zcard(stringKey);
                return null;
            }
            return this.session.zcard(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.zcount(stringKey, (Number)min, (Number)max);
                return null;
            }
            return this.session.zcount(stringKey, (Number)min, (Number)max);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.zincrby(stringKey, (Number)increment, stringValue);
                return null;
            }
            return Double.valueOf(this.session.zincrby(stringKey, (Number)increment, stringValue));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        String stringKey = RjcUtils.decode(destKey);
        String[] stringKeys = RjcUtils.decodeMultiple(sets);
        ZParams zparams = RjcUtils.toZParams(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline.zinterstore(stringKey, zparams, stringKeys);
                return null;
            }
            return this.session.zinterstore(stringKey, zparams, stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        String stringKey = RjcUtils.decode(destKey);
        String[] stringKeys = RjcUtils.decodeMultiple(sets);
        try {
            if (this.isPipelined()) {
                this.pipeline.zinterstore(stringKey, stringKeys);
                return null;
            }
            return this.session.zinterstore(stringKey, stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrange(stringKey, (int)start, (int)end);
                return null;
            }
            return RjcUtils.convertToSet(this.session.zrange(stringKey, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrangeWithScores(stringKey, (int)start, (int)end);
                return null;
            }
            return RjcUtils.convertElementScore(this.session.zrangeWithScores(stringKey, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrangeByScore(stringKey, minString, maxString);
                return null;
            }
            return RjcUtils.convertToSet(this.session.zrangeByScore(stringKey, minString, maxString));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrangeByScore(stringKey, minString, maxString, (int)offset, (int)count);
                return null;
            }
            return RjcUtils.convertToSet(this.session.zrangeByScore(stringKey, minString, maxString, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrevrangeByScore(stringKey, maxString, minString, (int)offset, (int)count);
                return null;
            }
            return RjcUtils.convertToSet(this.session.zrevrangeByScore(stringKey, maxString, minString, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrevrangeByScore(stringKey, maxString, minString);
                return null;
            }
            return RjcUtils.convertToSet(this.session.zrevrangeByScore(stringKey, maxString, minString));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrangeByScoreWithScores(stringKey, minString, maxString);
                return null;
            }
            return RjcUtils.convertElementScore(this.session.zrangeByScoreWithScores(stringKey, minString, maxString));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrevrangeWithScores(stringKey, (int)start, (int)end);
                return null;
            }
            return RjcUtils.convertElementScore(this.session.zrevrangeWithScores(stringKey, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrangeByScoreWithScores(stringKey, minString, maxString, (int)offset, (int)count);
                return null;
            }
            return RjcUtils.convertElementScore(this.session.zrangeByScoreWithScores(stringKey, minString, maxString, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrevrangeByScoreWithScores(stringKey, maxString, minString, (int)offset, (int)count);
                return null;
            }
            return RjcUtils.convertElementScore(this.session.zrevrangeByScoreWithScores(stringKey, maxString, minString, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrevrangeByScoreWithScores(stringKey, maxString, minString);
                return null;
            }
            return RjcUtils.convertElementScore(this.session.zrevrangeByScoreWithScores(stringKey, maxString, minString));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrank(stringKey, stringValue);
                return null;
            }
            return this.session.zrank(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean zRem(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrem(stringKey, stringValue);
                return null;
            }
            return this.session.zrem(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.zremrangeByRank(stringKey, (int)start, (int)end);
                return null;
            }
            return this.session.zremrangeByRank(stringKey, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        String stringKey = RjcUtils.decode(key);
        String minString = Double.toString(min);
        String maxString = Double.toString(max);
        try {
            if (this.isPipelined()) {
                this.pipeline.zremrangeByScore(stringKey, minString, maxString);
                return null;
            }
            return this.session.zremrangeByScore(stringKey, minString, maxString);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrevrange(stringKey, (int)start, (int)end);
                return null;
            }
            return RjcUtils.convertToSet(this.session.zrevrange(stringKey, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.zrevrank(stringKey, stringValue);
                return null;
            }
            return this.session.zrevrank(stringKey, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.zscore(stringKey, stringValue);
                return null;
            }
            return RjcUtils.convert(this.session.zscore(stringKey, stringValue));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        String stringKey = RjcUtils.decode(destKey);
        String[] stringKeys = RjcUtils.decodeMultiple(new byte[][]{destKey});
        ZParams zparams = RjcUtils.toZParams(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline.zunionstore(stringKey, zparams, stringKeys);
                return null;
            }
            return this.session.zunionstore(stringKey, zparams, stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        String stringKey = RjcUtils.decode(destKey);
        String[] stringKeys = RjcUtils.decodeMultiple(sets);
        try {
            if (this.isPipelined()) {
                this.pipeline.zunionstore(stringKey, stringKeys);
                return null;
            }
            return this.session.zunionstore(stringKey, stringKeys);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringField = RjcUtils.decode(field);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.hset(stringKey, stringField, stringValue);
                return null;
            }
            return this.session.hset(stringKey, stringField, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        String stringKey = RjcUtils.decode(key);
        String stringField = RjcUtils.decode(field);
        String stringValue = RjcUtils.decode(value);
        try {
            if (this.isPipelined()) {
                this.pipeline.hsetnx(stringKey, stringField, stringValue);
                return null;
            }
            return this.session.hsetnx(stringKey, stringField, stringValue);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean hDel(byte[] key, byte[] field) {
        String stringKey = RjcUtils.decode(key);
        String stringField = RjcUtils.decode(field);
        try {
            if (this.isPipelined()) {
                this.pipeline.hdel(stringKey, stringField);
                return null;
            }
            return this.session.hdel(stringKey, stringField);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        String stringKey = RjcUtils.decode(key);
        String stringField = RjcUtils.decode(field);
        try {
            if (this.isPipelined()) {
                this.pipeline.hexists(stringKey, stringField);
                return null;
            }
            return this.session.hexists(stringKey, stringField);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        String stringKey = RjcUtils.decode(key);
        String stringField = RjcUtils.decode(field);
        try {
            if (this.isPipelined()) {
                this.pipeline.hget(stringKey, stringField);
                return null;
            }
            return RjcUtils.encode(this.session.hget(stringKey, stringField));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.hgetAll(stringKey);
                return null;
            }
            return RjcUtils.encodeMap(this.session.hgetAll(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        String stringKey = RjcUtils.decode(key);
        String stringField = RjcUtils.decode(field);
        try {
            if (this.isPipelined()) {
                this.pipeline.hincrBy(stringKey, stringField, (int)delta);
                return null;
            }
            return this.session.hincrBy(stringKey, stringField, (int)delta);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.hkeys(stringKey);
                return null;
            }
            return RjcUtils.convertToSet(this.session.hkeys(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.hlen(stringKey);
                return null;
            }
            return this.session.hlen(stringKey);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        String stringKey = RjcUtils.decode(key);
        String[] stringKeys = RjcUtils.decodeMultiple(fields);
        try {
            if (this.isPipelined()) {
                this.pipeline.hmget(stringKey, stringKeys);
                return null;
            }
            return RjcUtils.convertToList(this.session.hmget(stringKey, stringKeys));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        String stringKey = RjcUtils.decode(key);
        Map<String, String> stringTuple = RjcUtils.decodeMap(tuple);
        try {
            if (this.isPipelined()) {
                this.pipeline.hmset(stringKey, stringTuple);
                return;
            }
            this.session.hmset(stringKey, stringTuple);
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        String stringKey = RjcUtils.decode(key);
        try {
            if (this.isPipelined()) {
                this.pipeline.hvals(stringKey);
                return null;
            }
            return RjcUtils.convertToList(this.session.hvals(stringKey));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            return this.session.publish(RjcUtils.decode(channel), RjcUtils.decode(message));
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new RjcSubscription(listener, this.subscriber);
            this.subscription.pSubscribe(patterns);
            this.subscriber.runSubscription();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new RjcSubscription(listener, this.subscriber);
            this.subscription.subscribe(channels);
            this.subscriber.runSubscription();
        }
        catch (Exception ex) {
            throw this.convertRjcAccessException(ex);
        }
    }
}

