/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.ZStoreArgs;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.ByteArrayOutput;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.channel.ChannelException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.lettuce.LettuceSubscription;
import org.springframework.data.redis.connection.lettuce.LettuceUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LettuceConnection
implements RedisConnection {
    private final RedisAsyncConnection<byte[], byte[]> asyncConn;
    private final com.lambdaworks.redis.RedisConnection<byte[], byte[]> con;
    private RedisAsyncConnection<byte[], byte[]> asyncTxConn;
    private com.lambdaworks.redis.RedisConnection<byte[], byte[]> txConn;
    private RedisAsyncConnection<byte[], byte[]> asyncBlockingConn;
    private com.lambdaworks.redis.RedisConnection<byte[], byte[]> blockingConn;
    private final RedisCodec<byte[], byte[]> codec = LettuceUtils.CODEC;
    private final long timeout;
    private boolean isClosed = false;
    private boolean isMulti = false;
    private boolean isPipelined = false;
    private boolean closeNativeConnection = true;
    private List<Command<?, ?, ?>> ppline;
    private RedisClient client;
    private volatile LettuceSubscription subscription;

    public LettuceConnection(RedisAsyncConnection<byte[], byte[]> connection, long timeout, RedisClient client) {
        this(connection, timeout, client, true);
    }

    public LettuceConnection(RedisAsyncConnection<byte[], byte[]> connection, long timeout, RedisClient client, boolean closeNativeConnection) {
        Assert.notNull(connection, (String)"a valid connection is required");
        this.asyncConn = connection;
        this.timeout = timeout;
        this.con = new com.lambdaworks.redis.RedisConnection(this.asyncConn);
        this.client = client;
        this.closeNativeConnection = closeNativeConnection;
    }

    protected DataAccessException convertLettuceAccessException(Exception ex) {
        if (ex instanceof RedisException) {
            return LettuceUtils.convertRedisAccessException((RuntimeException)((RedisException)ex));
        }
        if (ex instanceof ChannelException) {
            return new RedisConnectionFailureException("Redis connection failed", ex);
        }
        if (ex instanceof TimeoutException) {
            return new QueryTimeoutException("Redis command timed out", (Throwable)ex);
        }
        return new RedisSystemException("Unknown Lettuce exception", ex);
    }

    private Object await(Command cmd) {
        if (this.isMulti && cmd.type != CommandType.MULTI) {
            return null;
        }
        return this.getAsyncConnection().await(cmd, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"a valid command needs to be specified");
        try {
            String name = command.trim().toUpperCase();
            CommandType cmd = CommandType.valueOf((String)name);
            CommandArgs cmdArg = new CommandArgs(this.codec);
            if (!ObjectUtils.isEmpty((Object[])args)) {
                cmdArg.addKeys((Object[])args);
            }
            if (this.isPipelined()) {
                this.pipeline((Future<?>)this.getAsyncConnection().dispatch(cmd, (CommandOutput)new ByteArrayOutput(this.codec), cmdArg));
                return null;
            }
            return this.await(this.getAsyncConnection().dispatch(cmd, (CommandOutput)new ByteArrayOutput(this.codec), cmdArg));
        }
        catch (RedisException ex) {
            throw this.convertLettuceAccessException((Exception)((Object)ex));
        }
    }

    @Override
    public void close() throws DataAccessException {
        this.isClosed = true;
        if (this.asyncBlockingConn != null) {
            this.asyncBlockingConn.close();
            this.asyncBlockingConn = null;
            this.blockingConn = null;
        }
        if (this.asyncTxConn != null) {
            this.asyncTxConn.close();
            this.asyncTxConn = null;
            this.txConn = null;
        }
        if (this.closeNativeConnection) {
            try {
                this.asyncConn.close();
            }
            catch (RuntimeException ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        if (this.subscription != null) {
            if (this.subscription.isAlive()) {
                this.subscription.doClose();
            }
            this.subscription = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed && !this.isSubscribed();
    }

    public RedisAsyncConnection<byte[], byte[]> getNativeConnection() {
        return this.subscription != null ? this.subscription.pubsub : this.getAsyncConnection();
    }

    @Override
    public boolean isQueueing() {
        return this.isMulti;
    }

    @Override
    public boolean isPipelined() {
        return this.isPipelined;
    }

    @Override
    public void openPipeline() {
        if (!this.isPipelined) {
            this.isPipelined = true;
            this.ppline = new ArrayList();
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (this.isPipelined) {
            this.isPipelined = false;
            boolean done = this.getAsyncConnection().awaitAll((Future[])this.ppline.toArray(new Command[this.ppline.size()]));
            ArrayList<Object> results = new ArrayList<Object>(this.ppline.size());
            InvalidDataAccessApiUsageException problem = null;
            if (done) {
                for (Command<?, ?, ?> cmd : this.ppline) {
                    if (cmd.getOutput().hasError()) {
                        InvalidDataAccessApiUsageException err = new InvalidDataAccessApiUsageException(cmd.getOutput().getError());
                        if (problem == null) {
                            problem = err;
                        }
                        results.add(err);
                        continue;
                    }
                    results.add(cmd.get());
                }
            }
            this.ppline.clear();
            if (problem != null) {
                throw new RedisPipelineException((Exception)problem, (List<Object>)results);
            }
            if (done) {
                return results;
            }
            throw new RedisPipelineException((Exception)new QueryTimeoutException("Redis command timed out"));
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortArgs args = LettuceUtils.sort(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sort((Object)key, args));
                return null;
            }
            return this.getConnection().sort((Object)key, args);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        SortArgs args = LettuceUtils.sort(params);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sortStore((Object)key, args, (Object)sortKey));
                return null;
            }
            return this.getConnection().sortStore((Object)key, args, (Object)sortKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().dbsize());
                return null;
            }
            return this.getConnection().dbsize();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().flushdb());
                return;
            }
            this.getConnection().flushdb();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().flushall());
                return;
            }
            this.getConnection().flushall();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().bgsave());
                return;
            }
            this.getConnection().bgsave();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void bgWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().bgrewriteaof());
                return;
            }
            this.getConnection().bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().save());
                return;
            }
            this.getConnection().save();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().configGet(param));
                return null;
            }
            return this.getConnection().configGet(param);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().info());
                return null;
            }
            return LettuceUtils.info(this.getConnection().info());
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lastsave());
                return null;
            }
            return this.getConnection().lastsave().getTime();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().configSet(param, value));
                return;
            }
            this.getConnection().configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().configResetstat());
                return;
            }
            this.getConnection().configResetstat();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.getAsyncConnection().shutdown(true);
                return;
            }
            this.getConnection().shutdown(true);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().echo((Object)message));
                return null;
            }
            return (byte[])this.getConnection().echo((Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().ping());
                return null;
            }
            return this.getConnection().ping();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().del((Object[])keys));
                return null;
            }
            return this.getConnection().del((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void discard() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncTxConnection().discard());
                return;
            }
            this.getTxConnection().discard();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        this.isMulti = false;
        try {
            if (this.isPipelined()) {
                this.getAsyncTxConnection().exec();
                return null;
            }
            List results = this.getTxConnection().exec();
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().exists((Object)key));
                return null;
            }
            return this.getConnection().exists((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().expire((Object)key, seconds));
                return null;
            }
            return this.getConnection().expire((Object)key, seconds);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().expireat((Object)key, unixTime));
                return null;
            }
            return this.getConnection().expireat((Object)key, unixTime);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().keys((Object)pattern));
                return null;
            }
            List results = this.getConnection().keys((Object)pattern);
            return results != null ? new LinkedHashSet(results) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        this.isMulti = true;
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncTxConnection().multi());
                return;
            }
            this.getTxConnection().multi();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().persist((Object)key));
                return null;
            }
            return this.getConnection().persist((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().move((Object)key, dbIndex));
                return null;
            }
            return this.getConnection().move((Object)key, dbIndex);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().randomkey());
                return null;
            }
            return (byte[])this.getConnection().randomkey();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().rename((Object)oldName, (Object)newName));
                return;
            }
            this.getConnection().rename((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().renamenx((Object)oldName, (Object)newName));
                return null;
            }
            return this.getConnection().renamenx((Object)oldName, (Object)newName);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        throw new UnsupportedOperationException("Selecting a new database not supported due to shared connection. Use separate ConnectionFactorys to work with multiple databases");
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().ttl((Object)key));
                return null;
            }
            return this.getConnection().ttl((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().type((Object)key));
                return null;
            }
            String type = this.getConnection().type((Object)key);
            return type != null ? DataType.fromCode(type) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncTxConnection().unwatch());
                return;
            }
            this.getTxConnection().unwatch();
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncTxConnection().watch((Object[])keys));
                return;
            }
            this.getTxConnection().watch((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().get((Object)key));
                return null;
            }
            return (byte[])this.getConnection().get((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().set((Object)key, (Object)value));
                return;
            }
            this.getConnection().set((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().getset((Object)key, (Object)value));
                return null;
            }
            return (byte[])this.getConnection().getset((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().append((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().append((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().mget((Object[])keys));
                return null;
            }
            return this.getConnection().mget((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().mset(tuples));
                return;
            }
            this.getConnection().mset(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().msetnx(tuples));
                return;
            }
            this.getConnection().msetnx(tuples);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().setex((Object)key, time, (Object)value));
                return;
            }
            this.getConnection().setex((Object)key, time, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().setnx((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().setnx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().getrange((Object)key, start, end));
                return null;
            }
            return (byte[])this.getConnection().getrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().decr((Object)key));
                return null;
            }
            return this.getConnection().decr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().decrby((Object)key, value));
                return null;
            }
            return this.getConnection().decrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().incr((Object)key));
                return null;
            }
            return this.getConnection().incr((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().incrby((Object)key, value));
                return null;
            }
            return this.getConnection().incrby((Object)key, value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().getbit((Object)key, offset));
                return null;
            }
            Long result = this.getConnection().getbit((Object)key, offset);
            return result != null ? Boolean.valueOf(result == 1L) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().setbit((Object)key, offset, LettuceUtils.asBit(value)));
                return;
            }
            this.getConnection().setbit((Object)key, offset, LettuceUtils.asBit(value));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().setrange((Object)key, start, (Object)value));
                return;
            }
            this.getConnection().setrange((Object)key, start, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().strlen((Object)key));
                return null;
            }
            return this.getConnection().strlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lpush((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            return this.getConnection().lpush((Object)key, (Object[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().rpush((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            return this.getConnection().rpush((Object)key, (Object[])new byte[][]{value});
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncBlockingConnection().blpop((long)timeout, (Object[])keys));
                return null;
            }
            return LettuceUtils.toList((KeyValue<byte[], byte[]>)this.getBlockingConnection().blpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncBlockingConnection().brpop((long)timeout, (Object[])keys));
                return null;
            }
            return LettuceUtils.toList((KeyValue<byte[], byte[]>)this.getBlockingConnection().brpop((long)timeout, (Object[])keys));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lindex((Object)key, index));
                return null;
            }
            return (byte[])this.getConnection().lindex((Object)key, index);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().linsert((Object)key, LettuceUtils.convertPosition(where), (Object)pivot, (Object)value));
                return null;
            }
            return this.getConnection().linsert((Object)key, LettuceUtils.convertPosition(where), (Object)pivot, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().llen((Object)key));
                return null;
            }
            return this.getConnection().llen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lpop((Object)key));
                return null;
            }
            return (byte[])this.getConnection().lpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lrange((Object)key, start, end));
                return null;
            }
            return this.getConnection().lrange((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lrem((Object)key, count, (Object)value));
                return null;
            }
            return this.getConnection().lrem((Object)key, count, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lset((Object)key, index, (Object)value));
                return;
            }
            this.getConnection().lset((Object)key, index, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().ltrim((Object)key, start, end));
                return;
            }
            this.getConnection().ltrim((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().rpop((Object)key));
                return null;
            }
            return (byte[])this.getConnection().rpop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().rpoplpush((Object)srcKey, (Object)dstKey));
                return null;
            }
            return (byte[])this.getConnection().rpoplpush((Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncBlockingConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey));
                return null;
            }
            return (byte[])this.getBlockingConnection().brpoplpush((long)timeout, (Object)srcKey, (Object)dstKey);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().lpushx((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().lpushx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().rpushx((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().rpushx((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sAdd(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sadd((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            Long result = this.getConnection().sadd((Object)key, (Object[])new byte[][]{value});
            return result != null ? Boolean.valueOf(result == 1L) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().scard((Object)key));
                return null;
            }
            return this.getConnection().scard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sdiff((Object[])keys));
                return null;
            }
            return this.getConnection().sdiff((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sdiffstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.getConnection().sdiffstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sinter((Object[])keys));
                return null;
            }
            return this.getConnection().sinter((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sinterstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.getConnection().sinterstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sismember((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().sismember((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().smembers((Object)key));
                return null;
            }
            return this.getConnection().smembers((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().smove((Object)srcKey, (Object)destKey, (Object)value));
                return null;
            }
            return this.getConnection().smove((Object)srcKey, (Object)destKey, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().spop((Object)key));
                return null;
            }
            return (byte[])this.getConnection().spop((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().srandmember((Object)key));
                return null;
            }
            return (byte[])this.getConnection().srandmember((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean sRem(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().srem((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            Long result = this.getConnection().srem((Object)key, (Object[])new byte[][]{value});
            return result != null ? Boolean.valueOf(result == 1L) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sunion((Object[])keys));
                return null;
            }
            return this.getConnection().sunion((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().sunionstore((Object)destKey, (Object[])keys));
                return null;
            }
            return this.getConnection().sunionstore((Object)destKey, (Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zadd((Object)key, score, (Object)value));
                return null;
            }
            Long result = this.getConnection().zadd((Object)key, score, (Object)value);
            return result != null ? Boolean.valueOf(result == 1L) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zcard((Object)key));
                return null;
            }
            return this.getConnection().zcard((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zcount((Object)key, min, max));
                return null;
            }
            return this.getConnection().zcount((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zincrby((Object)key, increment, (Object)value));
                return null;
            }
            return this.getConnection().zincrby((Object)key, increment, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ZStoreArgs storeArgs = LettuceUtils.zArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets));
                return null;
            }
            return this.getConnection().zinterstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zinterstore((Object)destKey, (Object[])sets));
                return null;
            }
            return this.getConnection().zinterstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrange((Object)key, start, end));
                return null;
            }
            List results = this.getConnection().zrange((Object)key, start, end);
            return results != null ? new LinkedHashSet(results) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrangeWithScores((Object)key, start, end));
                return null;
            }
            return LettuceUtils.convertTuple(this.getConnection().zrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrangebyscore((Object)key, min, max));
                return null;
            }
            List results = this.getConnection().zrangebyscore((Object)key, min, max);
            return results != null ? new LinkedHashSet(results) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, min, max));
                return null;
            }
            return LettuceUtils.convertTuple(this.getConnection().zrangebyscoreWithScores((Object)key, min, max));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrevrangeWithScores((Object)key, start, end));
                return null;
            }
            return LettuceUtils.convertTuple(this.getConnection().zrevrangeWithScores((Object)key, start, end));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrangebyscore((Object)key, min, max, offset, count));
                return null;
            }
            List results = this.getConnection().zrangebyscore((Object)key, min, max, offset, count);
            return results != null ? new LinkedHashSet(results) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrangebyscoreWithScores((Object)key, min, max, offset, count));
                return null;
            }
            return LettuceUtils.convertTuple(this.getConnection().zrangebyscoreWithScores((Object)key, min, max, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrevrangebyscore((Object)key, max, min, offset, count));
                return null;
            }
            List results = this.getConnection().zrevrangebyscore((Object)key, max, min, offset, count);
            return results != null ? new LinkedHashSet(results) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrevrangebyscore((Object)key, max, min));
                return null;
            }
            List results = this.getConnection().zrevrangebyscore((Object)key, max, min);
            return results != null ? new LinkedHashSet(results) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, max, min, offset, count));
                return null;
            }
            return LettuceUtils.convertTuple(this.getConnection().zrevrangebyscoreWithScores((Object)key, max, min, offset, count));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrevrangebyscoreWithScores((Object)key, max, min));
                return null;
            }
            return LettuceUtils.convertTuple(this.getConnection().zrevrangebyscoreWithScores((Object)key, max, min));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrank((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().zrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean zRem(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrem((Object)key, (Object[])new byte[][]{value}));
                return null;
            }
            Long result = this.getConnection().zrem((Object)key, (Object[])new byte[][]{value});
            return result != null ? Boolean.valueOf(result == 1L) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zremrangebyrank((Object)key, start, end));
                return null;
            }
            return this.getConnection().zremrangebyrank((Object)key, start, end);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zremrangebyscore((Object)key, min, max));
                return null;
            }
            return this.getConnection().zremrangebyscore((Object)key, min, max);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrevrange((Object)key, start, end));
                return null;
            }
            List results = this.getConnection().zrevrange((Object)key, start, end);
            return results != null ? new LinkedHashSet(results) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zrevrank((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().zrevrank((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zscore((Object)key, (Object)value));
                return null;
            }
            return this.getConnection().zscore((Object)key, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        ZStoreArgs storeArgs = LettuceUtils.zArgs(aggregate, weights);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets));
                return null;
            }
            return this.getConnection().zunionstore((Object)destKey, storeArgs, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().zunionstore((Object)destKey, (Object[])sets));
                return null;
            }
            return this.getConnection().zunionstore((Object)destKey, (Object[])sets);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hset((Object)key, (Object)field, (Object)value));
                return null;
            }
            return this.getConnection().hset((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hsetnx((Object)key, (Object)field, (Object)value));
                return null;
            }
            return this.getConnection().hsetnx((Object)key, (Object)field, (Object)value);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hDel(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hdel((Object)key, (Object[])new byte[][]{field}));
                return null;
            }
            Long result = this.getConnection().hdel((Object)key, (Object[])new byte[][]{field});
            return result != null ? Boolean.valueOf(result == 1L) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hexists((Object)key, (Object)field));
                return null;
            }
            return this.getConnection().hexists((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hget((Object)key, (Object)field));
                return null;
            }
            return (byte[])this.getConnection().hget((Object)key, (Object)field);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hgetall((Object)key));
                return null;
            }
            return this.getConnection().hgetall((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hincrby((Object)key, (Object)field, delta));
                return null;
            }
            return this.getConnection().hincrby((Object)key, (Object)field, delta);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hkeys((Object)key));
                return null;
            }
            List result = this.getConnection().hkeys((Object)key);
            return result != null ? new LinkedHashSet(result) : null;
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hlen((Object)key));
                return null;
            }
            return this.getConnection().hlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hmget((Object)key, (Object[])fields));
                return null;
            }
            return this.getConnection().hmget((Object)key, (Object[])fields);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hmset((Object)key, tuple));
                return;
            }
            this.getConnection().hmset((Object)key, tuple);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().hvals((Object)key));
                return null;
            }
            return this.getConnection().hvals((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.getAsyncConnection().publish((Object)channel, (Object)message));
                return null;
            }
            return this.getConnection().publish((Object)channel, (Object)message);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new LettuceSubscription(listener, this.switchToPubSub());
            this.subscription.pSubscribe(patterns);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        try {
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.subscription = new LettuceSubscription(listener, this.switchToPubSub());
            this.subscription.subscribe(channels);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private void checkSubscription() {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
    }

    private RedisPubSubConnection<byte[], byte[]> switchToPubSub() {
        this.close();
        return this.client.connectPubSub(LettuceUtils.CODEC);
    }

    private void pipeline(Future<?> command) {
        this.ppline.add((Command)command);
    }

    private RedisAsyncConnection<byte[], byte[]> getAsyncConnection() {
        if (this.isQueueing()) {
            return this.getAsyncTxConnection();
        }
        return this.asyncConn;
    }

    private com.lambdaworks.redis.RedisConnection<byte[], byte[]> getConnection() {
        if (this.isQueueing()) {
            return this.getTxConnection();
        }
        return this.con;
    }

    private RedisAsyncConnection<byte[], byte[]> getAsyncBlockingConnection() {
        if (this.isQueueing()) {
            return this.getAsyncTxConnection();
        }
        if (this.asyncBlockingConn == null) {
            this.asyncBlockingConn = this.client.connectAsync(LettuceUtils.CODEC);
        }
        return this.asyncBlockingConn;
    }

    private com.lambdaworks.redis.RedisConnection<byte[], byte[]> getBlockingConnection() {
        if (this.isQueueing()) {
            return this.getTxConnection();
        }
        if (this.blockingConn == null) {
            this.blockingConn = new com.lambdaworks.redis.RedisConnection(this.getAsyncBlockingConnection());
        }
        return this.blockingConn;
    }

    private RedisAsyncConnection<byte[], byte[]> getAsyncTxConnection() {
        if (this.asyncTxConn == null) {
            this.asyncTxConn = this.client.connectAsync(LettuceUtils.CODEC);
        }
        return this.asyncTxConn;
    }

    private com.lambdaworks.redis.RedisConnection<byte[], byte[]> getTxConnection() {
        if (this.txConn == null) {
            this.txConn = new com.lambdaworks.redis.RedisConnection(this.getAsyncTxConnection());
        }
        return this.txConn;
    }
}

