/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.atomic;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisAtomicInteger
extends Number
implements Serializable,
BoundKeyOperations<String> {
    private volatile String key;
    private ValueOperations<String, Integer> operations;
    private RedisOperations<String, Integer> generalOps;

    public RedisAtomicInteger(String redisCounter, RedisConnectionFactory factory) {
        this(redisCounter, factory, null);
    }

    public RedisAtomicInteger(String redisCounter, RedisConnectionFactory factory, int initialValue) {
        this(redisCounter, factory, (Integer)initialValue);
    }

    private RedisAtomicInteger(String redisCounter, RedisConnectionFactory factory, Integer initialValue) {
        RedisTemplate<String, Integer> redisTemplate = new RedisTemplate<String, Integer>();
        redisTemplate.setKeySerializer(new StringRedisSerializer());
        redisTemplate.setValueSerializer(new GenericToStringSerializer<Integer>(Integer.class));
        redisTemplate.setExposeConnection(true);
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.afterPropertiesSet();
        this.key = redisCounter;
        this.generalOps = redisTemplate;
        this.operations = this.generalOps.opsForValue();
        if (initialValue == null) {
            if (this.operations.get(redisCounter) == null) {
                this.set(0);
            }
        } else {
            this.set(initialValue);
        }
    }

    public int get() {
        return this.operations.get(this.key);
    }

    public void set(int newValue) {
        this.operations.set(this.key, newValue);
    }

    public int getAndSet(int newValue) {
        return this.operations.getAndSet(this.key, newValue);
    }

    public boolean compareAndSet(final int expect, final int update) {
        return this.generalOps.execute(new SessionCallback<Boolean>(){

            @Override
            public Boolean execute(RedisOperations operations) {
                operations.watch(Collections.singleton(RedisAtomicInteger.this.key));
                if (expect == RedisAtomicInteger.this.get()) {
                    RedisAtomicInteger.this.generalOps.multi();
                    RedisAtomicInteger.this.set(update);
                    if (operations.exec() != null) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public int getAndIncrement() {
        return this.incrementAndGet() - 1;
    }

    public int getAndDecrement() {
        return this.decrementAndGet() + 1;
    }

    public int getAndAdd(int delta) {
        return this.addAndGet(delta) - delta;
    }

    public int incrementAndGet() {
        return this.operations.increment(this.key, 1L).intValue();
    }

    public int decrementAndGet() {
        return this.operations.increment(this.key, -1L).intValue();
    }

    public int addAndGet(int delta) {
        return this.operations.increment(this.key, delta).intValue();
    }

    public String toString() {
        return Integer.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.generalOps.expire(this.key, timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.generalOps.expireAt(this.key, date);
    }

    @Override
    public Long getExpire() {
        return this.generalOps.getExpire(this.key);
    }

    @Override
    public Boolean persist() {
        return this.generalOps.persist(this.key);
    }

    @Override
    public void rename(String newKey) {
        this.generalOps.rename(this.key, newKey);
        this.key = newKey;
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }
}

