/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

public class ParameterBindingContext {
    private final ValueProvider valueProvider;
    private final SpelExpressionParser expressionParser;
    private final EvaluationContext evaluationContext;

    @Nullable
    public Object bindableValueForIndex(int index) {
        return this.valueProvider.getBindableValue(index);
    }

    @Nullable
    public Object evaluateExpression(String expressionString) {
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(this.evaluationContext, Object.class);
    }

    public ParameterBindingContext(ValueProvider valueProvider, SpelExpressionParser expressionParser, EvaluationContext evaluationContext) {
        this.valueProvider = valueProvider;
        this.expressionParser = expressionParser;
        this.evaluationContext = evaluationContext;
    }

    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public SpelExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }
}

