/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ServerDescription;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class AbstractMonitor {
    private final Object mongoClient;

    @Deprecated
    protected AbstractMonitor(com.mongodb.MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    protected AbstractMonitor(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public Document getServerStatus() {
        return this.getDb("admin").runCommand((Bson)new Document("serverStatus", (Object)1).append("rangeDeleter", (Object)1).append("repl", (Object)1));
    }

    public MongoDatabase getDb(String databaseName) {
        if (this.mongoClient instanceof com.mongodb.MongoClient) {
            return ((com.mongodb.MongoClient)this.mongoClient).getDatabase(databaseName);
        }
        return ((MongoClient)this.mongoClient).getDatabase(databaseName);
    }

    protected com.mongodb.MongoClient getMongoClient() {
        if (this.mongoClient instanceof com.mongodb.MongoClient) {
            return (com.mongodb.MongoClient)this.mongoClient;
        }
        throw new IllegalStateException("A com.mongodb.MongoClient is required but was com.mongodb.client.MongoClient");
    }

    protected List<ServerAddress> hosts() {
        if (this.mongoClient instanceof com.mongodb.MongoClient) {
            return ((com.mongodb.MongoClient)this.mongoClient).getServerAddressList();
        }
        return ((MongoClient)this.mongoClient).getClusterDescription().getServerDescriptions().stream().map(ServerDescription::getAddress).collect(Collectors.toList());
    }
}

