/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.util.Assert;

public class MatchOperation
implements AggregationOperation {
    private final CriteriaDefinition criteriaDefinition;

    public MatchOperation(CriteriaDefinition criteriaDefinition) {
        Assert.notNull((Object)criteriaDefinition, (String)"Criteria must not be null!");
        this.criteriaDefinition = criteriaDefinition;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document("$match", (Object)context.getMappedObject(this.criteriaDefinition.getCriteriaObject()));
    }
}

