/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.MongoAdminOperations;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;

@ManagedResource(description="Mongo Admin Operations")
public class MongoAdmin
implements MongoAdminOperations {
    private final Object mongoClient;

    @Deprecated
    public MongoAdmin(com.mongodb.MongoClient mongoClient) {
        Assert.notNull((Object)mongoClient, (String)"MongoClient must not be null!");
        this.mongoClient = mongoClient;
    }

    public MongoAdmin(MongoClient client) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        this.mongoClient = client;
    }

    @Override
    @ManagedOperation
    public void dropDatabase(String databaseName) {
        this.getDB(databaseName).drop();
    }

    @Override
    @ManagedOperation
    public void createDatabase(String databaseName) {
        this.getDB(databaseName);
    }

    @Override
    @ManagedOperation
    public String getDatabaseStats(String databaseName) {
        return this.getDB(databaseName).runCommand((Bson)new Document("dbStats", (Object)1).append("scale", (Object)1024)).toJson();
    }

    @ManagedOperation
    public String getServerStatus() {
        return this.getDB("admin").runCommand((Bson)new Document("serverStatus", (Object)1).append("rangeDeleter", (Object)1).append("repl", (Object)1)).toJson();
    }

    MongoDatabase getDB(String databaseName) {
        if (this.mongoClient instanceof com.mongodb.MongoClient) {
            return ((com.mongodb.MongoClient)this.mongoClient).getDatabase(databaseName);
        }
        return ((MongoClient)this.mongoClient).getDatabase(databaseName);
    }
}

