/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.w3c.dom.Element;

public class MongoRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String MONGO_TEMPLATE_REF = "mongo-template-ref";
    private static final String CREATE_QUERY_INDEXES = "create-query-indexes";

    public String getModuleName() {
        return "MongoDB";
    }

    protected String getModulePrefix() {
        return "mongo";
    }

    public String getRepositoryFactoryBeanClassName() {
        return MongoRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Document.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(MongoRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)MONGO_TEMPLATE_REF, (String)"mongoOperations");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)CREATE_QUERY_INDEXES, (String)"createIndexesForQueryMethods");
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("mongoOperations", attributes.getString("mongoTemplateRef"));
        builder.addPropertyValue("createIndexesForQueryMethods", (Object)attributes.getBoolean("createIndexesForQueryMethods"));
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        if (!registry.containsBeanDefinition("mongoMappingContext")) {
            RootBeanDefinition definition = new RootBeanDefinition(MongoMappingContext.class);
            definition.setRole(2);
            definition.setSource(configurationSource.getSource());
            registry.registerBeanDefinition("mongoMappingContext", (BeanDefinition)definition);
        }
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return !metadata.isReactiveRepository();
    }
}

