/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.springframework.data.domain.Range;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MongoParametersParameterAccessor
extends ParametersParameterAccessor
implements MongoParameterAccessor {
    private final MongoQueryMethod method;

    public MongoParametersParameterAccessor(MongoQueryMethod method, Object[] values) {
        super((Parameters)method.getParameters(), values);
        this.method = method;
    }

    @Override
    public Range<Distance> getDistanceRange() {
        MongoParameters mongoParameters = this.method.getParameters();
        int rangeIndex = mongoParameters.getRangeIndex();
        if (rangeIndex != -1) {
            return (Range)this.getValue(rangeIndex);
        }
        int maxDistanceIndex = mongoParameters.getMaxDistanceIndex();
        Distance maxDistance = maxDistanceIndex == -1 ? null : (Distance)this.getValue(maxDistanceIndex);
        return new Range(null, (Comparable)maxDistance);
    }

    @Override
    public Point getGeoNearLocation() {
        int nearIndex = this.method.getParameters().getNearIndex();
        if (nearIndex == -1) {
            return null;
        }
        Object value = this.getValue(nearIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof double[]) {
            double[] typedValue = (double[])value;
            if (typedValue.length != 2) {
                throw new IllegalArgumentException("The given double[] must have exactly 2 elements!");
            }
            return new Point(typedValue[0], typedValue[1]);
        }
        return (Point)value;
    }

    @Override
    public TextCriteria getFullText() {
        int index = this.method.getParameters().getFullTextParameterIndex();
        return index >= 0 ? this.potentiallyConvertFullText(this.getValue(index)) : null;
    }

    protected TextCriteria potentiallyConvertFullText(Object fullText) {
        Assert.notNull((Object)fullText, (String)"Fulltext parameter must not be 'null'.");
        if (fullText instanceof String) {
            return TextCriteria.forDefaultLanguage().matching((String)fullText);
        }
        if (fullText instanceof Term) {
            return TextCriteria.forDefaultLanguage().matching((Term)fullText);
        }
        if (fullText instanceof TextCriteria) {
            return (TextCriteria)fullText;
        }
        throw new IllegalArgumentException(String.format("Expected full text parameter to be one of String, Term or TextCriteria but found %s.", ClassUtils.getShortName(fullText.getClass())));
    }
}

