/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.DefaultIdentifierGenerator;
import org.springframework.data.keyvalue.core.GeneratingIdAccessor;
import org.springframework.data.keyvalue.core.IdentifierGenerator;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.KeyValueCallback;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.KeyValuePersistenceExceptionTranslator;
import org.springframework.data.keyvalue.core.event.KeyValueEvent;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class KeyValueTemplate
implements KeyValueOperations,
ApplicationEventPublisherAware {
    private static final PersistenceExceptionTranslator DEFAULT_PERSISTENCE_EXCEPTION_TRANSLATOR = new KeyValuePersistenceExceptionTranslator();
    private final KeyValueAdapter adapter;
    private final MappingContext<? extends KeyValuePersistentEntity<?, ?>, ? extends KeyValuePersistentProperty<?>> mappingContext;
    private final IdentifierGenerator identifierGenerator;
    private PersistenceExceptionTranslator exceptionTranslator = DEFAULT_PERSISTENCE_EXCEPTION_TRANSLATOR;
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    private boolean publishEvents = true;
    private Set<Class<? extends KeyValueEvent>> eventTypesToPublish = Collections.emptySet();

    public KeyValueTemplate(KeyValueAdapter adapter) {
        this(adapter, (MappingContext<? extends KeyValuePersistentEntity<?, ?>, ? extends KeyValuePersistentProperty<?>>)new KeyValueMappingContext());
    }

    public KeyValueTemplate(KeyValueAdapter adapter, MappingContext<? extends KeyValuePersistentEntity<?, ?>, ? extends KeyValuePersistentProperty<?>> mappingContext) {
        Assert.notNull((Object)adapter, (String)"Adapter must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.adapter = adapter;
        this.mappingContext = mappingContext;
        this.identifierGenerator = DefaultIdentifierGenerator.INSTANCE;
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"ExceptionTranslator must not be null.");
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setEventTypesToPublish(Set<Class<? extends KeyValueEvent>> eventTypesToPublish) {
        if (CollectionUtils.isEmpty(eventTypesToPublish)) {
            this.publishEvents = false;
        } else {
            this.publishEvents = true;
            this.eventTypesToPublish = Collections.unmodifiableSet(eventTypesToPublish);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> T insert(T objectToInsert) {
        KeyValuePersistentEntity<?, ?> entity = this.getKeyValuePersistentEntity(objectToInsert);
        GeneratingIdAccessor generatingIdAccessor = new GeneratingIdAccessor(entity.getPropertyAccessor(objectToInsert), entity.getIdProperty(), this.identifierGenerator);
        Object id = generatingIdAccessor.getOrGenerateIdentifier();
        return this.insert(id, objectToInsert);
    }

    @Override
    public <T> T insert(Object id, T objectToInsert) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull(objectToInsert, (String)"Object to be inserted must not be null!");
        String keyspace = this.resolveKeySpace(objectToInsert.getClass());
        this.potentiallyPublishEvent(KeyValueEvent.beforeInsert(id, keyspace, objectToInsert.getClass(), objectToInsert));
        this.execute(adapter -> {
            if (adapter.contains(id, keyspace)) {
                throw new DuplicateKeyException(String.format("Cannot insert existing object with id %s!. Please use update.", id));
            }
            adapter.put(id, objectToInsert, keyspace);
            return null;
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterInsert(id, keyspace, objectToInsert.getClass(), objectToInsert));
        return objectToInsert;
    }

    @Override
    public <T> T update(T objectToUpdate) {
        KeyValuePersistentEntity<?, ?> entity = this.getKeyValuePersistentEntity(objectToUpdate);
        if (!entity.hasIdProperty()) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot determine id for type %s", ClassUtils.getUserClass(objectToUpdate)));
        }
        return this.update(entity.getIdentifierAccessor(objectToUpdate).getRequiredIdentifier(), objectToUpdate);
    }

    @Override
    public <T> T update(Object id, T objectToUpdate) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull(objectToUpdate, (String)"Object to be updated must not be null!");
        String keyspace = this.resolveKeySpace(objectToUpdate.getClass());
        this.potentiallyPublishEvent(KeyValueEvent.beforeUpdate(id, keyspace, objectToUpdate.getClass(), objectToUpdate));
        Object existing = this.execute(adapter -> adapter.put(id, objectToUpdate, keyspace));
        this.potentiallyPublishEvent(KeyValueEvent.afterUpdate(id, keyspace, objectToUpdate.getClass(), objectToUpdate, existing));
        return objectToUpdate;
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> type) {
        Assert.notNull(type, (String)"Type to fetch must not be null!");
        return this.executeRequired(adapter -> {
            Iterable<?> values = adapter.getAllOf(this.resolveKeySpace(type));
            ArrayList filtered = new ArrayList();
            for (Object candidate : values) {
                if (!KeyValueTemplate.typeCheck(type, candidate)) continue;
                filtered.add(type.cast(candidate));
            }
            return filtered;
        });
    }

    @Override
    public <T> Optional<T> findById(Object id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull(type, (String)"Type to fetch must not be null!");
        String keyspace = this.resolveKeySpace(type);
        this.potentiallyPublishEvent(KeyValueEvent.beforeGet(id, keyspace, type));
        Object result = this.execute(adapter -> {
            Object value = adapter.get(id, keyspace, type);
            if (value == null || KeyValueTemplate.typeCheck(type, value)) {
                return type.cast(value);
            }
            return null;
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterGet(id, keyspace, type, result));
        return Optional.ofNullable(result);
    }

    @Override
    public void delete(Class<?> type) {
        Assert.notNull(type, (String)"Type to delete must not be null!");
        String keyspace = this.resolveKeySpace(type);
        this.potentiallyPublishEvent(KeyValueEvent.beforeDropKeySpace(keyspace, type));
        this.execute(adapter -> {
            adapter.deleteAllOf(keyspace);
            return null;
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterDropKeySpace(keyspace, type));
    }

    @Override
    public <T> T delete(T objectToDelete) {
        Class type = ClassUtils.getUserClass(objectToDelete);
        KeyValuePersistentEntity<?, ?> entity = this.getKeyValuePersistentEntity(objectToDelete);
        return this.delete(entity.getIdentifierAccessor(objectToDelete).getIdentifier(), type);
    }

    @Override
    public <T> T delete(Object id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id for object to be deleted must not be null!");
        Assert.notNull(type, (String)"Type to delete must not be null!");
        String keyspace = this.resolveKeySpace(type);
        this.potentiallyPublishEvent(KeyValueEvent.beforeDelete(id, keyspace, type));
        Object result = this.execute(adapter -> adapter.delete(id, keyspace, type));
        this.potentiallyPublishEvent(KeyValueEvent.afterDelete(id, keyspace, type, result));
        return (T)result;
    }

    @Override
    public long count(Class<?> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        return this.adapter.count(this.resolveKeySpace(type));
    }

    @Override
    @Nullable
    public <T> T execute(KeyValueCallback<T> action) {
        Assert.notNull(action, (String)"KeyValueCallback must not be null!");
        try {
            return action.doInKeyValue(this.adapter);
        }
        catch (RuntimeException e) {
            throw this.resolveExceptionIfPossible(e);
        }
    }

    protected <T> T executeRequired(KeyValueCallback<T> action) {
        T result = this.execute(action);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException(String.format("KeyValueCallback %s returned null value!", action));
    }

    @Override
    public <T> Iterable<T> find(KeyValueQuery<?> query, Class<T> type) {
        return this.executeRequired(adapter -> {
            Iterable result = adapter.find(query, this.resolveKeySpace(type), type);
            ArrayList filtered = new ArrayList();
            for (Object candidate : result) {
                if (!KeyValueTemplate.typeCheck(type, candidate)) continue;
                filtered.add(type.cast(candidate));
            }
            return filtered;
        });
    }

    @Override
    public <T> Iterable<T> findAll(Sort sort, Class<T> type) {
        return this.find(new KeyValueQuery(sort), type);
    }

    @Override
    public <T> Iterable<T> findInRange(long offset, int rows, Class<T> type) {
        return this.find(new KeyValueQuery().skip(offset).limit(rows), type);
    }

    @Override
    public <T> Iterable<T> findInRange(long offset, int rows, Sort sort, Class<T> type) {
        return this.find(new KeyValueQuery(sort).skip(offset).limit(rows), type);
    }

    @Override
    public long count(KeyValueQuery<?> query, Class<?> type) {
        return this.executeRequired(adapter -> adapter.count(query, this.resolveKeySpace(type)));
    }

    @Override
    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public void destroy() throws Exception {
        this.adapter.clear();
    }

    private KeyValuePersistentEntity<?, ?> getKeyValuePersistentEntity(Object objectToInsert) {
        return (KeyValuePersistentEntity)this.mappingContext.getRequiredPersistentEntity(ClassUtils.getUserClass((Object)objectToInsert));
    }

    private String resolveKeySpace(Class<?> type) {
        return ((KeyValuePersistentEntity)this.mappingContext.getRequiredPersistentEntity(type)).getKeySpace();
    }

    private RuntimeException resolveExceptionIfPossible(RuntimeException e) {
        DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(e);
        return translatedException != null ? translatedException : e;
    }

    private void potentiallyPublishEvent(KeyValueEvent event) {
        if (this.eventPublisher == null) {
            return;
        }
        if (this.publishEvents && (this.eventTypesToPublish.isEmpty() || this.eventTypesToPublish.contains(((Object)((Object)event)).getClass()))) {
            this.eventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    private static boolean typeCheck(Class<?> requiredType, @Nullable Object candidate) {
        return candidate == null || ClassUtils.isAssignable(requiredType, candidate.getClass());
    }
}

